<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

/**
 * @param $p_structure
 */
function structure($p_structure)
{
    foreach ($p_structure as $l_category => $l_properties)
    {
        $l_example = [];
        $l_cat = explode(':', $l_category);

        echo '<h3>' . $l_cat[0] . ' (' . $l_cat[1] . ')</h3>
            <table>
                <thead>
                    <tr>
                        <th width="35%">Feldname</th>
                        <th width="20%">Key</th>
                        <th width="15%">Datentyp</th>
                        <th width="20%">Referenz</th>
                        <th width="10%">Optional</th>
                    </tr>
                </thead>';

        foreach ($l_properties as $l_prop)
        {
            echo '<tr>
                <td>' . $l_prop['title'] . '</td>
                <td>' . $l_prop['key'] . '</td>
                <td>' . $l_prop['type'] . '</td>
                <td>' . $l_prop['ref'] . '</td>
                <td>' . $l_prop['optional'] . '</td>
            </tr>';

            $l_example[] = "&nbsp;&nbsp;'" . $l_prop['key'] . "' => '" . $l_prop['type'] . "'";
        } // foreach

        echo '</table>';

        echo "<br />";
        echo '<strong>Beispiel-Array:</strong>';

        echo '<div>
            array(<br />' . implode(',<br />', $l_example) . '<br />);
            </div>';
    } // foreach
} // function

global $g_comp_database;

if (!$g_comp_database)
{
    die('You need to be logged in.');
} // if

$l_dao       = new isys_cmdb_dao($g_comp_database);
$l_structure = [];
$i           = 0;

foreach (['g', 's'] as $l_cattype)
{
    $l_categories = $l_dao->get_isysgui('isysgui_cat' . $l_cattype);

    while ($l_row = $l_categories->get_row())
    {
        $l_class = $l_row['isysgui_cat' . $l_cattype . '__class_name'];

        if (class_exists($l_class))
        {
            $l_category_dao = new $l_class($g_comp_database);
            $l_properties   = $l_category_dao->get_properties();

            foreach ($l_properties as $l_key => $l_prop)
            {
                $l_structure[$l_cattype][_L($l_row['isysgui_cat' . $l_cattype . '__title']) . ':' . $l_row['isysgui_cat' . $l_cattype . '__const']][$l_key] = [
                    'title'    => _L($l_prop[C__PROPERTY__INFO][C__PROPERTY__INFO__TITLE]),
                    'key'      => $l_key,
                    'type'     => $l_prop[C__PROPERTY__DATA][C__PROPERTY__DATA__TYPE],
                    'field'    => $l_prop[C__PROPERTY__DATA][C__PROPERTY__DATA__FIELD],
                    'ref'      => $l_prop[C__PROPERTY__DATA][C__PROPERTY__DATA__REFERENCES][1],
                    'optional' => $l_prop[C__PROPERTY__CHECK][C__PROPERTY__CHECK__MANDATORY] === true ? 'Nein' : 'Ja',
                ];
            } // foreach

            $i++;
        } // if
    } // while
} // foreach

echo '<h1>Kategorie-Felder für Datenarrays</h1>';

if (is_array($l_structure['g']))
{
    echo '<h2>' . _L('LC__CMDB__GLOBAL_CATEGORIES') . ' (catg)</h2>';
    structure($l_structure['g']);
} // if

if (is_array($l_structure['s']))
{
    echo '<h2>' . _L('LC__CMDB__SPECIFIC_CATEGORIES') . ' (cats)</h2>';
    structure($l_structure['s']);
} // if

echo '<style type="text/css">
    html {
        font-family: Tahoma,Geneva,Helvetica,sans-serif;
        line-height:1.15
    }

    body {
        margin:10px
    }

    table {
        table-layout: fixed;
        border-spacing: 0;
        width: 60%;
    }

    thead {
        background: #ddd
    }

    thead th {
        text-align: left
    }

    tbody tr {
        font-size: 80%;
        background-color: #fff
    }

    tbody td {
        padding: 2px
    }

    tbody tr:nth-child(2n+1) {
        background-color: #eee
    }

    tbody tr:hover {
        background-color: #d6dde5
    }

    div {
        border: 1px solid #888;
        background-color: #ccc;
        font-family: Monaco, Courier New, monospace;
        font-size: 9pt;
        padding: 5px;
    }
    </style>';