<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.9
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
/**
 * i-doit - Updates
 *
 * Remove all dead relation objects from type cluster memberships
 *
 * @package     i-doit
 * @subpackage  Update
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @author      Van Quyen Hoang <qhoang@i-doit.com>
 */

$g_migration_identifier = "cleanup_relation_type_clustermemberships";

try
{
    if ($this->is_migration_done($g_migration_identifier))
    {
        $g_migration_log[] = '<span class="bold">Cleanup for relation type "Cluster memberships" has already been executed.</span>';
    }
    else
    {
        global $g_comp_database;

        $dao               = isys_cmdb_dao::instance($g_comp_database);
        $g_migration_log[] = '<span class="bold">Starting clean up for relation type "Cluster memberships".</span>';

        // Relation Type ID Cluster memberships
        $relationTypeId = $dao->retrieve(
            'SELECT isys_relation_type__id AS typeId FROM isys_relation_type WHERE isys_relation_type__const = ' . $dao->convert_sql_text('C__RELATION_TYPE__CLUSTER_MEMBERSHIPS')
        )
            ->get_row_value('typeId');

        // Query which removes all dead relation objects from type cluster memberships
        $delete = 'DELETE FROM isys_catg_relation_list WHERE isys_catg_relation_list__isys_relation_type__id = ' .
            $dao->convert_sql_id($relationTypeId) . ' AND isys_catg_relation_list__id NOT IN (SELECT isys_catg_cluster_members_list__isys_catg_relation_list__id FROM isys_catg_cluster_members_list)';
        $dao->update($delete);

        if($dao->apply_update())
        {
            $g_migration_log[] = '<span class="bold">Finished migration!</span>';
            // Set flag in DB.
            $this->migration_done($g_migration_identifier);
        }
        else
        {
            $g_migration_log[] = '<span class="red">Dead relations from type "Cluster memberships" could not be deleted.</span>';
        } // if
    } // if
}
catch(Exception $e)
{
    $g_migration_log[] = '<span class="red">Migration could not be completed. Please retry the update migration step 6 only for this database.</span>';
} // catch