<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.9
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
/**
 * i-doit - Updates
 *
 * Migrate controller/handler rights for commands
 *
 * @package     i-doit
 * @subpackage  Update
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @author      Kevin Mauel <kmauel@i-doit.com>
 */

$g_migration_identifier = "migrate_handler_rights_for_commands";

try
{
    if ($this->is_migration_done($g_migration_identifier))
    {
        $g_migration_log[] = '<span class="bold">Set migrate handler rights for commands migration has already been executed.</span>';
    }
    else
    {
        global $g_comp_database;

        $dao               = isys_cmdb_dao::instance($g_comp_database);
        $g_migration_log[] = '<span class="bold">Starting migration of all controller rights</span>';

        $mappingControllerToCommands = [
            'isys_handler_addldapdn' => [
                'SyncDistinguishedNamesCommand'
            ],
            'isys_handler_archivelog ' => [
                'ArchiveCommand'
            ],
            'isys_handler_autoup ' => [
                'AutoUpdateCommand'
            ],
            'isys_handler_cleanup_auth ' => [
                'CleanupAuthCommand'
            ],
            'isys_handler_cleanup_objects ' => [
                'ObjectCleanupCommand'
            ],
            'isys_handler_csv_import ' => [
                'ImportCsvCommand'
            ],
            'isys_handler_import ' => [
                'ImportCmdbCommand',
                'ImportInventoryCommand'
            ],
            'isys_handler_increment_config ' => [
                'IncrementConfigCommand'
            ],
            'isys_handler_isc_dhcpd ' => [
                'IscDhcpdCommand'
            ],
            'isys_handler_ldap ' => [
                'SyncCommand'
            ],
            'isys_handler_maintenance ' => [
                'MaintenanceCommand'
            ],
            'isys_handler_notifications ' => [
                'HandleNotificationsCommand'
            ],
            'isys_handler_ocs ' => [
                'ImportOcsCommand'
            ],
            'isys_handler_regenerate_relations ' => [
                'RegenerateRelationsCommand'
            ],
            'isys_handler_search_index ' => [
                'IndexerCommand',
                'SearchCommand'
            ],
            'isys_handler_syslog ' => [
                'ParseCommand'
            ],
            'isys_handler_tenants ' => [
                'AddTenantCommand',
                'DeleteTenantCommand',
                'DisableTenantCommand',
                'EnableTenantCommand',
                'ListTenantsCommand'
            ],
            'isys_handler_updatecheck ' => [
                'UpdateCheckCommand'
            ],
            'isys_handler_workflow ' => [
                'HandleWorkflowsCommand'
            ],
            'isys_handler_check_mk ' => [
                'CheckMkCommand'
            ],
            'isys_handler_check_mk_export' => [
                'CheckMkExportCommand'
            ],
            'isys_handler_document' => [
                'CompileDocumentsCommand'
            ],
            'isys_handler_jdisc' => [
                'JDiscImportCommand'
            ],
            'isys_handler_jdisc_discovery' => [
                'JDiscDiscoveryCommand'
            ],
            'isys_handler_maintenance_notification' => [
                'MaintenanceNotificationCommand'
            ],
            'isys_handler_nagios' => [
                'NagiosCommand'
            ],
            'isys_handler_nagios_export' => [
                'NagiosExportCommand'
            ],
            'isys_handler_report' => [
                'ReportExportCommand'
            ]
        ];

        // Migrate wildcard rights
        $g_comp_database->query("INSERT INTO isys_auth (`isys_auth__isys_obj__id`, `isys_auth__type`, `isys_auth__isys_module__id`, `isys_auth__path`, `isys_auth__status`) SELECT `isys_auth__isys_obj__id`, `isys_auth__type`, `isys_auth__isys_module__id`, REPLACE(`isys_auth__path`, 'CONTROLLERHANDLER', 'COMMAND'), `isys_auth__status` FROM isys_auth WHERE isys_auth__path = 'CONTROLLERHANDLER' OR isys_auth__path = 'CONTROLLERHANDLER/*';");

        // Migrate rights with mapping
        foreach ($mappingControllerToCommands as $controller => $commands) {
            if (count($commands) === 1) {
                $g_comp_database->query("INSERT INTO isys_auth (`isys_auth__isys_obj__id`, `isys_auth__type`, `isys_auth__isys_module__id`, `isys_auth__path`, `isys_auth__status`) SELECT `isys_auth__isys_obj__id`, `isys_auth__type`, `isys_auth__isys_module__id`, REPLACE(`isys_auth__path`, 'CONTROLLERHANDLER/".strtoupper($controller)."', 'COMMAND/".strtoupper($commands[0])."'), `isys_auth__status` FROM isys_auth WHERE isys_auth__path = 'CONTROLLERHANDLER/".strtoupper($controller)."' AND isys_auth__path != 'CONTROLLERHANDLER/*';");
            } else {
                foreach ($commands as $command) {
                    $g_comp_database->query("INSERT INTO isys_auth (`isys_auth__isys_obj__id`, `isys_auth__type`, `isys_auth__isys_module__id`, `isys_auth__path`, `isys_auth__status`) SELECT `isys_auth__isys_obj__id`, `isys_auth__type`, `isys_auth__isys_module__id`, REPLACE(`isys_auth__path`, 'CONTROLLERHANDLER/".strtoupper($controller)."', 'COMMAND/".strtoupper($command)."'), `isys_auth__status` FROM isys_auth WHERE isys_auth__path = 'CONTROLLERHANDLER/".strtoupper($controller)."' AND isys_auth__path != 'CONTROLLERHANDLER/*';");
                }
            }
        }

        $g_migration_log[] = '<span class="bold">Finished migration!</span>';

        // Set flag in DB.
        $this->migration_done($g_migration_identifier);
    } // if
}
catch(Exception $e)
{
    $g_migration_log[] = '<span class="red">Migration could not be completed. Please retry the update migration step 6 only for this database.</span>';
} // catch
