<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
/**
 * @version   $Version
 * @author    Viviane Götzen <vgoetzen@synetics.de>
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */

$g_migration_identifier = "set_event_log_command";

try
{
    if ($this->is_migration_done($g_migration_identifier))
    {
        $g_migration_log[] = '<span class="bold">Set event log command migration has already been executed.</span>';
    }
    else
    {
        global $g_comp_database;

        $dao               = isys_cmdb_dao::instance($g_comp_database);
        $g_migration_log[] = '<span class="bold">Starting migration of all event log entries.</span>';

        // Retrieve all event log
        $queryEvents  = 'SELECT isys_event_subscription__command, isys_event_subscription__id FROM isys_event_subscription;';
        $resultEvents = $dao->retrieve($queryEvents);

        $dao->set_autocommit(false);

        while ($rowEvent = $resultEvents->get_row())
        {
            $dao->update(
                'UPDATE 
                isys_event_log 
              SET isys_event_log__command = ' . $dao->convert_sql_text($rowEvent['isys_event_subscription__command']) . ' 
              WHERE isys_event_log__command IS NULL AND isys_event_log__isys_event_subscription__id = ' . $dao->convert_sql_id($rowEvent['isys_event_subscription__id']) . ';'
            );
        } // while

        $dao->apply_update();
        $dao->set_autocommit(true);

        $g_migration_log[] = '<span class="bold">Finished migration!</span>';

        // Set flag in DB.
        $this->migration_done($g_migration_identifier);
    } // if
}
catch (Exception $e)
{

    $g_migration_log[] = '<span class="red">Migration could not be completed. Please retry the update migration step 6 only for this database.</span>';
} // catch