<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.9
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
/**
 * i-doit - Updates
 *
 * Set logbook event in all logbook entries
 *
 * @package     i-doit
 * @subpackage  Update
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @author      Van Quyen Hoang <qhoang@i-doit.com>
 */

$g_migration_identifier = "set_logbook_event";

try
{
    if ($this->is_migration_done($g_migration_identifier))
    {
        $g_migration_log[] = '<span class="bold">Set logbook events migration has already been executed.</span>';
    }
    else
    {
        global $g_comp_database;

        $dao               = isys_cmdb_dao::instance($g_comp_database);
        $g_migration_log[] = '<span class="bold">Startin migration of all logbook entries.</span>';
        $logbookEvents     = [];

        // Retrieve all logbook events
        $queryEvents  = 'SELECT isys_logbook_event__id, isys_logbook_event__const FROM isys_logbook_event';
        $resultEvents = $dao->retrieve($queryEvents);
        while ($rowEvent = $resultEvents->get_row())
        {
            $logbookEvents[$rowEvent['isys_logbook_event__const']] = $rowEvent['isys_logbook_event__id'];
        } // while
        // Free memory
        $resultEvents->free_result();

        $dao->set_autocommit(false);

        // Set mysql settings for the current session
        $g_comp_database->query('SET @@session.transaction_alloc_block_size = 20480;');
        $g_comp_database->query('SET @@session.transaction_prealloc_size = 20480;');

        // deactivate autocommit
        $g_comp_database->query('SET @@session.autocommit = 0;');

        $g_comp_database->begin();

        // Update all logbook entries and fill isys_logbook__isys_logbook_event__id with the specified id
        foreach ($logbookEvents AS $logbookConst => $logbookEventID)
        {
            $updateQuery = 'UPDATE 
                isys_logbook 
              SET isys_logbook__isys_logbook_event__id = \'' . $logbookEventID . '\' 
              WHERE isys_logbook__isys_logbook_event__id IS NULL AND isys_logbook__event_static = \'' . $logbookConst . '\';';
            $g_comp_database->query($updateQuery);
        } // foreach

        $g_comp_database->commit();
        // reactivate autocommit
        $g_comp_database->query('SET @@session.autocommit = 1;');

        $g_migration_log[] = '<span class="bold">Finished migration!</span>';

        // Set flag in DB.
        $this->migration_done($g_migration_identifier);
    } // if
}
catch(Exception $e)
{
    $g_migration_log[] = '<span class="red">Migration could not be completed. Please retry the update migration step 6 only for this database.</span>';
} // catch