<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

/**
 * AJAX
 *
 * @package     i-doit
 * @subpackage  General
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_ajax_handler_table extends isys_ajax_handler
{
    /**
     * Method for initializing the AJAX request.
     */
    public function init()
    {
        header('Content-Type: application/json');

        try
        {
            $l_response = [
                'success' => true,
                'message' => null
            ];

            switch ($_GET['func'])
            {
                case 'saveColumnWidths':
                    $l_response['data'] = $this->saveColumnWidths($_GET['identifier'], isys_format_json::decode($_POST['columns']));
                    break;
            } // switch
        }
        catch (Exception $e)
        {
            $l_response = [
                'success' => false,
                'data'    => null,
                'message' => $e->getMessage()
            ];
        } // try

        echo isys_format_json::encode($l_response);
        $this->_die();
    } // function

    /**
     * This method will save the column-widhts of a Table to the set identifier (will be placed inside the user settings).
     *
     * @param string $p_identifier
     * @param array  $p_columns
     *
     * @return boolean
     */
    protected function saveColumnWidths($p_identifier, array $p_columns)
    {
        isys_usersettings::set($p_identifier, $p_columns);

        return true;
    } // function
} // class