<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

use phpseclib\Crypt;

/**
 * i-doit
 *
 * Helper methods for Crypting via phpseclib
 *
 * @package     i-doit
 * @subpackage  Helper
 * @author      Kevin Mauel <kmauel@i-doit.org>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       1.0
 */
class isys_helper_crypt
{
    /**
     * Encrypt a string, hashed with a string located in config.inc.php
     *
     * @author      Kevin Mauel <kmauel@i-doit.org>
     *
     * @param $p_string
     *
     * @return string
     */
    public static function encrypt($p_string)
    {
        global $g_crypto_hash;

        $cipher = new Crypt\Rijndael();
        $cipher->setKey($g_crypto_hash);
        $l_iv = Crypt\Random::string($cipher->getBlockLength() >> 3);
        $cipher->setIV($l_iv);

        $l_crypted_string = $l_iv . '|$$|' . $cipher->encrypt($p_string);

        return base64_encode($l_crypted_string);
    }

    /**
     * Decrypt a string
     *
     * @author      Kevin Mauel <kmauel@i-doit.org>
     *
     * @param $p_string
     *
     * @return string
     */
    public static function decrypt($p_string)
    {
        global $g_crypto_hash;

        $cipher = new Crypt\Rijndael();
        $l_crypted_array = explode('|$$|', base64_decode($p_string, true));
        $cipher->setKey($g_crypto_hash);
        $cipher->setIV($l_crypted_array[0]);

        $l_decrypted_string = $cipher->decrypt($l_crypted_array[1]);

        return $l_decrypted_string;
    }

} // class
?>
