<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

/**
 * i-doit
 *
 * DAO: ObjectType list for logical interfaces (subcategory of network)
 *
 * @package     i-doit
 * @subpackage  CMDB_Category_lists
 * @author      Niclas Potthast <npotthast@i-doit.org>
 * @author      Van Quyen Hoang <qhoang@i-doit.org>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_dao_list_catg_network_ifacel extends isys_component_dao_category_table_list
{
    /**
     * Return constant of category.
     *
     * @return  integer
     * @author  Niclas Potthast <npotthast@i-doit.org>
     */
    public function get_category()
    {
        return C__CMDB__SUBCAT__NETWORK_INTERFACE_L;
    } // function

    /**
     * Return constant of category type
     *
     * @return  integer
     * @author  Niclas Potthast <npotthast@i-doit.org>
     */
    public function get_category_type()
    {
        return C__CMDB__CATEGORY__TYPE_GLOBAL;
    } // function

    /**
     * Exchange column to create individual links in columns
     *
     * @param   array & $p_arrRow
     *
     * @author  Niclas Potthast <npotthast@i-doit.org>
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public function modify_row(&$p_arrRow)
    {
        $l_nInterfaceID = $p_arrRow["isys_catg_log_port_list__id"];
        $l_dao          = new isys_cmdb_dao_category_g_network_ifacel($this->m_db);
        $l_quick_info   = new isys_ajax_handler_quick_info();
        $l_empty_value  = isys_tenantsettings::get('gui.empty_value', '-');

        $l_layer_2_nets = $l_dao->get_attached_layer_2_net($l_nInterfaceID, null);

        if (is_array($l_layer_2_nets) > 0)
        {
            $p_arrRow["object_connection"] = [];
            $i                             = 1;
            foreach ($l_layer_2_nets AS $l_obj_id)
            {
                if ($i++ === isys_tenantsettings::get('cmdb.limits.port-lists-layer2', 5))
                {
                    $p_arrRow["object_connection"][] = '...';
                    break;
                } // if

                $p_arrRow["object_connection"][] = $l_quick_info->get_quick_info($l_obj_id, $l_dao->get_obj_name_by_id_as_string($l_obj_id));
            } // foreach
        }

        $p_arrRow['attached_log_port'] = $l_empty_value;

        if ($p_arrRow['isys_catg_log_port_list__isys_catg_log_port_list__id'] > 0)
        {
            $l_attached_log_port = $l_dao->get_attached_log_port($p_arrRow['isys_catg_log_port_list__isys_catg_log_port_list__id'])
                ->get_row();

            if ($l_attached_log_port)
            {
                $p_arrRow['attached_log_port'] = '<ul class="list-style-none m0"><li>' . $l_quick_info->get_quick_info(
                        $l_attached_log_port['isys_obj__id'],
                        $l_dao->get_obj_name_by_id_as_string($l_attached_log_port['isys_obj__id']) . ' -> ' . $l_attached_log_port['isys_catg_log_port_list__title']
                    ) . '</li></ul>';
            }
        }

        if (!$p_arrRow["object_connection"])
        {
            $p_arrRow["object_connection"] = $l_empty_value;
        }

        // Here we fetch the assigned host addresses.
        $l_hostaddress_dao = new isys_cmdb_dao_category_g_ip($this->m_db);

        $l_hostaddress_res = $l_hostaddress_dao->get_data(
            null,
            null,
            'AND isys_catg_ip_list__isys_catg_log_port_list__id = ' . (int) $p_arrRow['isys_catg_log_port_list__id']
        );

        $p_arrRow['isys_cats_net_ip_addresses_list__title'] = [];

        while ($l_hostaddress_row = $l_hostaddress_res->get_row())
        {
            $p_arrRow['isys_cats_net_ip_addresses_list__title'][] = $l_hostaddress_row['isys_cats_net_ip_addresses_list__title'];
        } // while

        if (count($p_arrRow['isys_cats_net_ip_addresses_list__title']) > 0)
        {
            $p_arrRow['isys_cats_net_ip_addresses_list__title'] = implode(', ', $p_arrRow['isys_cats_net_ip_addresses_list__title']);
        }
        else
        {
            $p_arrRow['isys_cats_net_ip_addresses_list__title'] = $l_empty_value;
        } // if
    } // function

    /**
     * Returns array with table headers.
     *
     * @return  array
     * @author  Niclas Potthast <npotthast@i-doit.org>
     */
    public function get_fields()
    {
        return [
            "isys_catg_log_port_list__title"         => "LC__CMDB__CATG__INTERFACE_L__TITLE",
            "isys_netx_ifacel_type__title"           => "LC__CMDB__CATS__NET__TYPE",
            "isys_cats_net_ip_addresses_list__title" => "LC__CMDB__TREE__SYSTEM__SETTINGS_SYSTEM__IPS",
            "object_connection"                      => "LC__CMDB__CATS__NET__LAYER2_NET",
            "attached_log_port"                      => "LC__CMDB__CATG__NETWORK__TARGET_OBJECT"
        ];
    } // function
} // class