<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

namespace idoit\Module\Cmdb\Model\Ci\Category\G\Accounting;

use idoit\Module\Cmdb\Model\Ci\Category\DynamicCallbackInterface;

/**
 * i-doit
 *
 * Accounting Category "GuaranteeStatus" callback.
 *
 * @package     i-doit
 * @subpackage  Cmdb
 * @author      Kevin Mauel<kmauel@i-doit.com>
 * @version     1.9.2
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class GuaranteeStatus implements DynamicCallbackInterface
{
    /**
     * Render method.
     *
     * @param string $data
     * @param mixed  $extra
     *
     * @return mixed
     */
    public static function render($data, $extra = null)
    {
        if ($data === null)
        {
            return '';
        } // if

        $data = explode(',', $data);

        $dao = \isys_cmdb_dao_category_g_accounting::instance(\isys_application::instance()->container->database);
        $result = $dao->calculate_guarantee_status(strtotime($data[0]), $data[1], $data[2]);

        return $result;
    } // function
} // class
