<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
namespace idoit\Module\Cmdb\Model\Ci\Table;

/**
 * i-doit
 *
 * Ci Table Config
 *
 * @package     i-doit
 * @subpackage  Cmdb
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @since       1.8
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Config
{
    /**
     * @var  array
     */
    private $properties;

    /**
     * @var  string
     */
    private $sortingProperty;

    /**
     * @var  string
     */
    private $sortingDirection;

    /**
     * @var  string
     */
    private $filterProperty;

    /**
     * @var  string
     */
    private $filterValue;

    /**
     * @var  boolean
     */
    private $rowClickable;

    /**
     * @var  integer
     */
    private $groupingType;

    /**
     * @var  boolean
     */
    private $filterWildcard;

    /**
     * @var  string
     */
    private $advancedOptionMemoryUnit;

    /**
     * @return Property[]
     */
    public function getProperties()
    {
        return $this->properties;
    } // function

    /**
     * @param Property $properties
     *
     * @return Config
     */
    public function addProperty(Property $properties)
    {
        $this->properties[] = $properties;

        return $this;
    } // function

    /**
     * @param Property[] $properties
     *
     * @return Config
     * @throws \isys_exception_general
     */
    public function setProperties(array $properties)
    {
        foreach ($properties as $property)
        {
            if (!is_a($property, 'idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property'))
            {
                throw new \isys_exception_general('All array items need to be instances of "idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property"!');
            } // if
        } // function

        $this->properties = $properties;

        return $this;
    } // function

    /**
     * @return  string
     */
    public function getSortingProperty()
    {
        return $this->sortingProperty;
    } // function

    /**
     * @param string $sortingProperty
     *
     * @return  Config
     */
    public function setSortingProperty($sortingProperty)
    {
        $this->sortingProperty = $sortingProperty;

        return $this;
    } // function

    /**
     * @return  string
     */
    public function getSortingDirection()
    {
        return $this->sortingDirection;
    } // function

    /**
     * @param string $sortingDirection
     *
     * @return  Config
     */
    public function setSortingDirection($sortingDirection)
    {
        $sortingDirection = strtoupper($sortingDirection);

        if ($sortingDirection === 'ASC' || $sortingDirection === 'DESC')
        {
            $this->sortingDirection = $sortingDirection;
        } // if

        return $this;
    } // function

    /**
     * @return  string
     */
    public function getFilterProperty()
    {
        return $this->filterProperty;
    } // function

    /**
     * @param string $filterProperty
     *
     * @return  Config
     */
    public function setFilterProperty($filterProperty)
    {
        $this->filterProperty = $filterProperty;

        return $this;
    } // function

    /**
     * @return  string
     */
    public function getFilterValue()
    {
        return $this->filterValue;
    } // function

    /**
     * @param string $filterValue
     *
     * @return  Config
     */
    public function setFilterValue($filterValue)
    {
        $this->filterValue = $filterValue;

        return $this;
    } // function

    /**
     * @return  boolean
     */
    public function isRowClickable()
    {
        return $this->rowClickable;
    } // function

    /**
     * @param boolean $rowClickable
     *
     * @return  Config
     */
    public function setRowClickable($rowClickable)
    {
        $this->rowClickable = !!$rowClickable;

        return $this;
    } // function

    /**
     * @return  integer
     */
    public function getGroupingType()
    {
        return $this->groupingType;
    } // function

    /**
     * @param integer $groupingType
     *
     * @return  Config
     */
    public function setGroupingType($groupingType)
    {
        $this->groupingType = (int) $groupingType;

        return $this;
    } // function

    /**
     * @return boolean
     * @author   Van Quyen Hoang <qhoang@i-doit.com>
     */
    public function isFilterWildcard()
    {
        return $this->filterWildcard;
    } // function

    /**
     * @param boolean $filterWildcard
     *
     * @author   Van Quyen Hoang <qhoang@i-doit.com>
     */
    public function setFilterWildcard($filterWildcard)
    {
        $this->filterWildcard = !!$filterWildcard;

        return $this;
    }

    /**
     * @return string
     * @author   Van Quyen Hoang <qhoang@i-doit.com>
     */
    public function getAdvancedOptionMemoryUnit()
    {
        return $this->advancedOptionMemoryUnit;
    }

    /**
     * @param string $advancedOptionMemoryUnit
     *
     * @author   Van Quyen Hoang <qhoang@i-doit.com>
     */
    public function setAdvancedOptionMemoryUnit($advancedOptionMemoryUnit)
    {
        $this->advancedOptionMemoryUnit = $advancedOptionMemoryUnit;
        return $this;
    } // function
} // class