<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
namespace idoit\Module\Cmdb\Model\Matcher;

use idoit\Component\Provider\Factory;

/**
 * i-doit
 *
 * Ci Models
 *
 * @package     i-doit
 * @subpackage  Cmdb
 * @author      Van Quyen Hoang <qhoang@i-doit.com>
 * @version     1.8
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Data
{
    use Factory;

    /**
     * Data result
     *
     * @var int
     */
    private $dataResult = [];

    /**
     * @return Data[]
     */
    public function getDataResult()
    {
        return $this->dataResult;
    }

    /**
     * @param Data[]
     *
     * @return $this
     */
    public function setDataResult(array $dataResult)
    {
        $this->dataResult = $dataResult;

        return $this;
    }
}