<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
namespace idoit\Module\Cmdb\Model\Summary;

use idoit\Model\Summary\Summarizable;
use idoit\Model\Summary\SystemSummary;

/**
 * i-doit
 *
 * Object type summary
 *
 * @package     i-doit
 * @subpackage  Cmdb
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @version     1.7
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class ObjectTypeSummary extends SystemSummary implements Summarizable
{
    /**
     * @inherit
     * @var string
     */
    protected $namespace = 'cmdb.objectType';

    /**
     * Initialize object counts for a newly created object type
     *
     * @param $objectTypeId
     *
     * @return $this
     * @throws \isys_exception_dao
     */
    public function objectTypeCreated($objectTypeId)
    {
        for ($i = 1;$i <= 7;$i++)
        {
            $this->queryDao->update(
                sprintf(
                    'INSERT INTO isys_summary SET isys_summary__namespace = "%s", isys_summary__key = "%s", isys_summary__count = 0;',
                    $this->namespace,
                    $this->concat($objectTypeId, $i)
                )
            );
        }

        return $this;
    }

    /**
     * Remove summary for deleted objec types
     *
     * @param $objectTypeId
     *
     * @return $this
     * @throws \isys_exception_dao
     */
    public function objectTypeDeleted($objectTypeId)
    {
        $this->queryDao->update(
            sprintf(
                'DELETE FROM isys_summary WHERE isys_summary__namespace = "%s" AND isys_summary__key LIKE "%s";',
                $this->namespace,
                $this->concat($objectTypeId) . '.%'
            )
        );
        return $this;
    }

    /**
     * Decrement summary on object deletion
     *
     * @param $objectId
     */
    public function objectDeleted($objectId)
    {
        $objectData   = \isys_cmdb_dao::instance($this->queryDao->get_database_component())->get_object($objectId)->get_row();
        $objectTypeId = $objectData['isys_obj__isys_obj_type__id'];
        $oldStatus    = $objectData['isys_obj__status'];

        $this->decrement(
            $this->concat($objectTypeId, $oldStatus)
        );
        $this->queryDao->update(
            sprintf(
                'DELETE FROM isys_summary WHERE isys_summary__key LIKE "%s";',
                $objectId . '.%'
            )
        );
    }

    /**
     * Decrement summary on object deletion
     *
     * @param $objectId
     */
    public function objectStatusChanged($objectId, $newStatus)
    {
        $objectData   = \isys_cmdb_dao::instance($this->queryDao->get_database_component())->get_object($objectId)->get_row();
        $objectTypeId = $objectData['isys_obj__isys_obj_type__id'];
        $oldStatus    = $objectData['isys_obj__status'];

        if ($oldStatus <> $newStatus)
        {
            $this->decrement($this->concat($objectTypeId, $oldStatus));
            $this->increment($this->concat($objectTypeId, $newStatus));
        }
    }

    /**
     * Summarize category count. Currently only works with record status normal
     *
     * @param $objectId
     * @param $categoryId
     *
     * @return bool
     */
    public function summarize($objectTypeId, $status = C__RECORD_STATUS__NORMAL)
    {
        return $this->set(
            $this->concat($objectTypeId, $status),
            (int) $this->queryDao->retrieve(
                sprintf(
                    'SELECT count(*) AS count FROM isys_obj WHERE isys_obj__status = "%s" AND isys_obj__isys_obj_type__id = "%s";',
                    $status,
                    $objectTypeId
                )
            )
                ->get_row_value('count')
        );
    }

    /**
     * @param $objectType
     * @param $status
     *
     * @return int
     */
    public function getCount($objectType, $status)
    {
        return $this->get(
            $this->concat($objectType, $status)
        );
    }
}