<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
namespace idoit\Module\Report\SqlQuery\Structure;

/**
 * Select Group By
 *
 * @package     idoit\Module\Report\SqlQuery\Structure
 * @subpackage  Core
 * @author      Van Quyen Hoang <qhoang@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       1.8
 */
class SelectGroupBy
{
    /**
     * @var array
     */
    private $groupBy = [];

    /**
     * @var string
     */
    private $groupConcatSelection = '';

    /**
     * @return array
     * @author   Van Quyen Hoang <qhoang@i-doit.com>
     */
    public function getGroupBy()
    {
        return $this->groupBy;
    }

    /**
     * @param array $groupBy
     *
     * @author   Van Quyen Hoang <qhoang@i-doit.com>
     */
    public function setGroupBy($groupBy)
    {
        $this->groupBy = $groupBy;
        return $this;
    }

    /**
     * @param $groupBy
     *
     * @return $this
     * @author   Van Quyen Hoang <qhoang@i-doit.com>
     */
    public function addGroupBy($groupBy)
    {
        $this->groupBy[] = $groupBy;
        return $this;
    }

    /**
     * @return string
     * @author   Van Quyen Hoang <qhoang@i-doit.com>
     */
    public function getGroupConcatSelection()
    {
        return $this->groupConcatSelection;
    }

    /**
     * @param string $groupConcatSelection
     *
     * @author   Van Quyen Hoang <qhoang@i-doit.com>
     */
    public function setGroupConcatSelection($groupConcatSelection)
    {
        $this->groupConcatSelection = $groupConcatSelection;
        return $this;
    }

    /**
     * @return string
     */
    public function __toString()
    {
        if(count($this->getGroupBy()))
        {
            return ' GROUP BY ' . implode(', ', $this->getGroupBy()) . ' ';
        } // if
        return '';
    } // function

    /**
     * @param $groupBy
     *
     * @return SelectGroupBy
     */
    public static function factory($groupBy, $groupConcatSelection = '')
    {
        $selectGroupBy = new SelectGroupBy($groupBy);
        return $selectGroupBy->setGroupConcatSelection($groupConcatSelection);
    } // function

    /**
     * JoinQuery constructor.
     *
     * @param $joinQuery
     */
    public function __construct(array $groupBy = [])
    {
        $this->setGroupBy($groupBy);
    } // function

    /**
     * @return SelectGroupBy
     * @author   Van Quyen Hoang <qhoang@i-doit.com>
     */
    public function __clone()
    {
        $selectGroupBy = new SelectGroupBy($this->getGroupBy());
        return $selectGroupBy->setGroupConcatSelection($this->getGroupConcatSelection());
    } // function
}