<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

/**
 * i-doit
 *
 * User settings.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Niclas Potthast <npotthast@i-doit.org>
 * @author      Dennis Stücken <dstuecken@i-doit.org>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_user_settings extends isys_module implements isys_module_interface
{
    const DISPLAY_IN_MAIN_MENU = false;

    // Define, if this module shall be displayed in the named menus.
    const DISPLAY_IN_SYSTEM_MENU = true;
    /**
     * @var bool
     */
    protected static $m_licenced = true;
    private $m_pageinfo = [
        C__SETTINGS_PAGE__USER   => [
            'title'    => 'LC__SETTINGS__SYSTEM__TITLE',
            'method'   => 'user',
            'template' => 'content/bottom/content/module__settings__user.tpl'
        ],
        C__SETTINGS_PAGE__SYSTEM => [
            'title'    => 'LC__CMDB__TREE__SYSTEM__SETTINGS__USER__SYSTEM_SETTINGS',
            'method'   => 'system',
            'template' => 'modules/system_settings/index.tpl'
        ]
    ];

    /**
     * @param   isys_module_request $p_req
     *
     * @return  boolean
     */
    public function init(isys_module_request $p_req)
    {
        return true;
    } // function

    /**
     * Method for retrieving the breadcrumb part.
     *
     * @param   array $p_gets
     *
     * @return  array
     */
    public function breadcrumb_get(&$p_gets)
    {
        return [[_L($this->m_pageinfo[$_GET[C__GET__SETTINGS_PAGE]]['title']) => null]];
    } // function

    /**
     * This method builds the tree for the menu.
     *
     * @param   isys_component_tree $p_tree
     * @param   boolean             $p_system_module
     * @param   integer             $p_parent
     *
     * @author  Leonard Fischer <lfischer@i-doit.org>
     * @since   0.9.9-7
     * @see     isys_module::build_tree()
     */
    public function build_tree(isys_component_tree $p_tree, $p_system_module = true, $p_parent = null)
    {
        global $g_dirs;

        $l_objUser = isys_component_dao_user::instance(isys_application::instance()->database);

        $l_nUserID      = $l_objUser->get_current_user_id();
        $l_strUserTitle = $l_objUser->get_user_title($l_nUserID);

        $l_gets = isys_module_request::get_instance()
            ->get_gets();

        $l_mod_gets = $l_gets;

        unset($l_mod_gets['what']);

        $l_parent = -1;
        $i        = 0;

        if ($p_system_module)
        {
            $l_parent                          = $p_tree->find_id_by_title('Modules');
            $l_mod_gets[C__GET__MODULE_SUB_ID] = C__MODULE__USER_SETTINGS;
        } // if

        if (null !== $p_parent && is_int($p_parent))
        {
            $l_root = $p_parent;
        }
        else
        {
            $l_root = $p_tree->add_node(
                C__MODULE__USER_SETTINGS . $i,
                $l_parent,
                $l_strUserTitle
            );
        } // if

        $l_mod_gets[C__GET__TREE_NODE]     = C__MODULE__USER_SETTINGS . (++$i);
        $l_mod_gets[C__GET__SETTINGS_PAGE] = C__SETTINGS_PAGE__USER;
        $p_tree->add_node(
            C__MODULE__USER_SETTINGS . $i,
            $l_root,
            _L("LC__CMDB__TREE__SYSTEM__SETTINGS__USER__PRESENTATION"),
            isys_helper_link::create_url($l_mod_gets),
            null,
            $g_dirs["images"] . "icons/silk/application_form_edit.png",
            (int) ($_GET[C__GET__TREE_NODE] == C__MODULE__USER_SETTINGS . $i)
        );

        if (isys_auth_cmdb::instance()->is_allowed_to(isys_auth::EXECUTE, 'list_config'))
        {
            $p_tree->add_node(
                C__MODULE__USER_SETTINGS . (++$i),
                $l_root,
                _L('LC__CMDB__TREE__SYSTEM__OBJECT_LIST'),
                isys_helper_link::create_url([
                    C__GET__MODULE_ID     => C__MODULE__SYSTEM,
                    C__GET__MODULE_SUB_ID => C__MODULE__CMDB,
                    C__GET__TREE_NODE     => C__MODULE__USER_SETTINGS . $i,
                    C__GET__SETTINGS_PAGE => 'list'
                ]),
                null,
                $g_dirs["images"] . 'icons/silk/table_edit.png',
                (int) ($_GET[C__GET__TREE_NODE] == C__MODULE__USER_SETTINGS . $i)
            );
        } // if

        $p_tree->add_node(
            C__MODULE__USER_SETTINGS . (++$i),
            $l_root,
            _L('LC__LOGIN__SETTINGS'),
            isys_helper_link::create_url(
                [
                    C__GET__MODULE_ID     => C__MODULE__SYSTEM,
                    C__GET__MODULE_SUB_ID => C__MODULE__USER_SETTINGS,
                    C__GET__TREE_NODE     => C__MODULE__USER_SETTINGS . $i,
                    C__GET__SETTINGS_PAGE => 'login'
                ]
            ),
            null,
            $g_dirs["images"] . 'icons/silk/key.png',
            (int) ($_GET[C__GET__TREE_NODE] == C__MODULE__USER_SETTINGS . $i)
        );

        $p_tree->add_node(
            C__MODULE__USER_SETTINGS . (++$i),
            $l_root,
            _L('LC__CMDB__TREE__SYSTEM__SETTINGS__USER__SYSTEM_SETTINGS'),
            isys_helper_link::create_url(
                [
                    C__GET__MODULE_ID     => C__MODULE__SYSTEM,
                    C__GET__MODULE_SUB_ID => C__MODULE__USER_SETTINGS,
                    C__GET__TREE_NODE     => C__MODULE__USER_SETTINGS . $i,
                    C__GET__SETTINGS_PAGE => C__SETTINGS_PAGE__SYSTEM
                ]
            ),
            null,
            $g_dirs["images"] . 'icons/silk/outline.png',
            (int) ($_GET[C__GET__TREE_NODE] == C__MODULE__USER_SETTINGS . $i)
        );
    } // function

    /**
     * User specific settings.
     *
     * @author Dennis Stücken <dstuecken@synetics.de>
     */
    public function start()
    {
        global $index_includes, $g_config;

        $l_tplclass = isys_application::instance()->template;
        $l_navbar   = isys_component_template_navbar::getInstance();

        if (empty($_GET[C__GET__SETTINGS_PAGE]))
        {
            return false;
        } // if

        if ($_GET[C__GET__MODULE_ID] != C__MODULE__SYSTEM)
        {
            $l_tree = isys_module_request::get_instance()
                ->get_menutree();
            $this->build_tree($l_tree, false);
            $l_tplclass->assign("menu_tree", $l_tree->process($_GET[C__GET__TREE_NODE]));
        } // if

        $l_gets  = isys_module_request::get_instance()
            ->get_gets();
        $l_posts = isys_module_request::get_instance()
            ->get_posts();

        $l_objUser = isys_component_dao_user::instance(isys_application::instance()->database);
        $l_nUserID = $l_objUser->get_current_user_id();

        // navbar stuff.
        $l_navbar->set_active(true, C__NAVBAR_BUTTON__EDIT);

        if (isys_glob_get_param("navMode") == C__NAVMODE__EDIT)
        {
            $l_navbar->set_visible(false, C__NAVBAR_BUTTON__EDIT)
                ->set_active(true, C__NAVBAR_BUTTON__SAVE)
                ->set_active(true, C__NAVBAR_BUTTON__CANCEL);
        } // if

        switch ($_GET[C__GET__SETTINGS_PAGE])
        {
            case C__SETTINGS_PAGE__USER:

                // Handle navmode actions.
                if (isset($l_posts["navMode"]) && $l_posts["navMode"] == C__NAVMODE__SAVE)
                {
                    try
                    {
                        $l_objUser->save_settings(C__SETTINGS_PAGE__USER, $l_posts);

                        if ($g_config['theme_selectable'])
                        {
                            $l_objUser->save_settings(C__SETTINGS_PAGE__THEME, $l_posts);
                        }

                        isys_notify::success(_L('LC__UNIVERSAL__SUCCESSFULLY_SAVED'));
                        isys_locale::get_instance()
                            ->reset_cache(true);
                    }
                    catch (isys_exception_general $e)
                    {
                        $l_error = $e->getMessage();
                        isys_notify::error($l_error, ['sticky' => true]);
                    } // try
                } // if
                break;

            case 'login':
                return $this->process_user_login();
                break;
        }

        /**
         * Route into function
         */
        if ($l_nUserID > 0 && isset($this->m_pageinfo[$l_gets[C__GET__SETTINGS_PAGE]]['method']))
        {
            if ($this->m_pageinfo[$l_gets[C__GET__SETTINGS_PAGE]]['method'] && method_exists($this, $this->m_pageinfo[$l_gets[C__GET__SETTINGS_PAGE]]['method']))
            {
                call_user_func(
                    [
                        $this,
                        $this->m_pageinfo[$l_gets[C__GET__SETTINGS_PAGE]]['method']
                    ],
                    $l_nUserID
                );
            } // if
        } // if

        // Set template body.
        $index_includes['contentbottom'] = $this->m_pageinfo[$l_gets[C__GET__SETTINGS_PAGE]]['template'];

        return null;
    }

    /**
     * Method for displaying the user-settings.
     *
     * @param  integer $p_user_id
     */
    private function user($p_user_id)
    {
        $l_res = isys_component_dao_user::instance(isys_application::instance()->database)
            ->get_user_settings();

        $l_arLanguages      = isys_glob_get_language_constants();
        $l_objLocale        = isys_locale::get(isys_application::instance()->database, $p_user_id);
        $l_nLangSetting     = $l_objLocale->get_setting(LC_LANG);
        $l_nTimeSetting     = $l_objLocale->get_setting(LC_TIME);
        $l_nMonetarySetting = $l_objLocale->get_setting(LC_MONETARY);
        $l_nNumericSetting  = $l_objLocale->get_setting(LC_NUMERIC);

        $l_default_treeview = [
            C__CMDB__VIEW__TREE_OBJECTTYPE => _L('LC__CMDB__OBJECT_VIEW'),
            C__CMDB__VIEW__TREE_LOCATION   => _L('LC__CMDB__MENU_TREE_VIEW')
        ];

        $l_default_treetype = [
            C__CMDB__VIEW__TREE_LOCATION__LOCATION      => _L('LC__CMDB__TREE_VIEW__LOCATION'),
            C__CMDB__VIEW__TREE_LOCATION__LOGICAL_UNITS => _L('LC__CMDB__TREE_VIEW__LOGICAL_UNIT'),
            C__CMDB__VIEW__TREE_LOCATION__COMBINED      => _L('LC__CMDB__TREE_VIEW__COMBINED'),
        ];

        $l_rules = [
            // Language settings.
            'C__CATG__OVERVIEW__LANGUAGE'         => [
                'p_arData'        => $l_arLanguages,
                'p_strSelectedID' => $l_nLangSetting,
                'p_strClass'      => 'input input-mini'
            ],
            // Date settings.
            'C__CATG__OVERVIEW__DATE_FORMAT'      => [
                'p_arData'        => $l_arLanguages,
                'p_strSelectedID' => $l_nTimeSetting,
                'p_strClass'      => 'input input-mini'
            ],
            // Numeric settings.
            'C__CATG__OVERVIEW__NUMERIC_FORMAT'   => [
                'p_arData'        => $l_arLanguages,
                'p_strSelectedID' => $l_nNumericSetting,
                'p_strClass'      => 'input input-mini'
            ],
            // Monetary settings.
            'C__CATG__OVERVIEW__MONETARY_FORMAT'  => [
                'p_strTable'      => 'isys_currency',
                'p_strSelectedID' => $l_nMonetarySetting,
                'p_strClass'      => 'input input-mini'
            ],
            // Default tree view.
            'C__CATG__OVERVIEW__DEFAULT_TREEVIEW' => [
                'p_arData'        => $l_default_treeview,
                'p_strSelectedID' => $l_res['isys_user_locale__default_tree_view'] ?: C__CMDB__VIEW__TREE_OBJECTTYPE,
                'p_strClass'      => 'input input-mini'
            ],
            // Default tree type.
            'C__CATG__OVERVIEW__DEFAULT_TREETYPE' => [
                'p_arData'        => $l_default_treetype,
                'p_strSelectedID' => $l_res['isys_user_locale__default_tree_type'],
                'p_strClass'      => 'input input-mini'
            ],
            'C__CATG__OVERVIEW__BROWSER_LANGUAGE' => [
                'p_arData'        => get_smarty_arr_YES_NO(),
                'p_strSelectedID' => $l_objLocale->get_setting('browser_language'),
                'p_strClass'      => 'input input-mini'
            ]
        ];

        $this->theme();

        isys_application::instance()->template->smarty_tom_add_rules("tom.content.bottom", $l_rules);
        isys_application::instance()->template->assign("useBrowserLanguage", $l_objLocale->get_setting('browser_language'));
    } // function

    /**
     * Process generic settings (config.inc.php)
     */
    private function system()
    {
        if (isset($_POST['settings']['user']) && is_array($_POST['settings']['user']))
        {
            foreach ($_POST['settings']['user'] as $l_key => $l_value)
            {
                isys_usersettings::set($l_key, $l_value);
            } // foreach

            isys_notify::success(_L('LC__UNIVERSAL__SUCCESSFULLY_SAVED'));
        } // if

        isys_component_template_navbar::getInstance()
            ->set_active(true, C__NAVBAR_BUTTON__SAVE)
            ->set_visible(false, C__NAVBAR_BUTTON__EDIT)
            ->set_save_mode('quick');

        $l_settings   = isys_usersettings::get();
        $l_definition = isys_usersettings::get_definition();
        ksort($l_definition);

        isys_application::instance()->template
            ->activate_editmode()
            ->assign("bShowCommentary", false)
            ->assign('content_title', _L('LC__CMDB__TREE__SYSTEM__SETTINGS__USER__SYSTEM_SETTINGS') . ' (' . _L('LC__CMDB__LOGBOOK__USER') . ')')
            ->assign('definition', $l_definition)
            ->assign('disableTabs', true)
            ->assign('systemWideKey', 'user')
            ->assign('settings', $l_settings);
    } // function

    /**
     * User settings for the theme.
     */
    private function theme()
    {
        global $g_config;

        $l_themes = [];

        isys_application::instance()->template->assign(
            "g_current_theme",
            isys_component_dao_user::instance(isys_application::instance()->database)
                ->get_user_theme_as_string()
        );

        if (isys_glob_get_param("navMode") == C__NAVMODE__EDIT)
        {
            $l_handle = opendir($g_config["base_dir"] . "src/themes/");

            while ($l_file = readdir($l_handle))
            {
                if (strpos($l_file, ".") !== 0 && is_dir($g_config["base_dir"] . "src/themes/" . $l_file))
                {
                    $l_themes[$l_file] = $l_file;
                } // if
            } // while

            closedir($l_handle);

            isys_application::instance()->template->assign("g_themes", $l_themes);
        } // if
    } // function

    /**
     * Method for displaying the "change password" page.
     *
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    private function process_user_login()
    {
        global $index_includes, $g_comp_database;

        $l_rules                                                          = [];
        $l_rules["C__CONTACT__PERSON_PASSWORD"]["p_strValue"]             = '';
        $l_rules["C__CONTACT__PERSON_PASSWORD_SECOND"]["p_strSelectedID"] = '';

        isys_application::instance()->template->smarty_tom_add_rules("tom.content.bottom", $l_rules);

        $l_error    = '';
        $l_user_dao = isys_component_dao_user::instance($g_comp_database);
        $l_user_id  = $l_user_dao->get_current_user_id();

        $l_row = $l_user_dao->get_user($l_user_id)
            ->get_row();

        if (isys_glob_get_param("navMode") == C__NAVMODE__SAVE)
        {
            $_POST['C__CONTACT__PERSON_PASSWORD']        = trim($_POST['C__CONTACT__PERSON_PASSWORD']);
            $_POST['C__CONTACT__PERSON_PASSWORD_SECOND'] = trim($_POST['C__CONTACT__PERSON_PASSWORD_SECOND']);
            $l_password_minlength                        = (int) isys_tenantsettings::get('minlength.login.password', 4);

            if (!empty($_POST['C__CONTACT__PERSON_PASSWORD']) && strlen($_POST['C__CONTACT__PERSON_PASSWORD']) >= $l_password_minlength && $_POST['C__CONTACT__PERSON_PASSWORD'] == $_POST['C__CONTACT__PERSON_PASSWORD_SECOND']
            )
            {
                isys_cmdb_dao_category_s_person_login::instance($g_comp_database)
                    ->change_password($l_row['isys_cats_person_list__id'], $_POST['C__CONTACT__PERSON_PASSWORD']);
                isys_notify::success(_L('LC__UNIVERSAL__SUCCESSFULLY_SAVED'));
            }
            else
            {
                $_GET['navMode']  = C__NAVMODE__EDIT;
                $_POST['navMode'] = C__NAVMODE__EDIT;

                $l_rules["C__CONTACT__PERSON_PASSWORD"]["p_strValue"]        = $_POST['C__CONTACT__PERSON_PASSWORD'];
                $l_rules["C__CONTACT__PERSON_PASSWORD_SECOND"]["p_strValue"] = $_POST['C__CONTACT__PERSON_PASSWORD_SECOND'];

                if ($_POST['C__CONTACT__PERSON_PASSWORD'] != $_POST['C__CONTACT__PERSON_PASSWORD_SECOND'])
                {
                    $l_error = _L('LC__LOGIN__PASSWORDS_DONT_MATCH');
                }
                else
                {
                    $l_error = _L('LC__LOGIN__SAVE_ERROR', $l_password_minlength);
                } // if
                isys_notify::error($l_error, ['sticky' => true]);
            } // if
        } // if

        // navbar stuff.
        $l_navbar = isys_component_template_navbar::getInstance()
            ->set_active(true, C__NAVBAR_BUTTON__EDIT);

        if (isys_glob_get_param("navMode") == C__NAVMODE__EDIT)
        {
            $l_navbar->set_visible(false, C__NAVBAR_BUTTON__EDIT)
                ->set_active(true, C__NAVBAR_BUTTON__SAVE)
                ->set_active(true, C__NAVBAR_BUTTON__CANCEL);
        } // if

        isys_application::instance()->template->assign('title', _L('LC__LOGIN__SETTINGS_CHANGE', [$l_row['isys_cats_person_list__title']]))
            ->smarty_tom_add_rules("tom.content.bottom", $l_rules);

        $index_includes['contentbottomcontent'] = 'content/bottom/content/module__settings__user_login.tpl';
    } // function
} // class
