<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

/**
 * Interface which has to be implemented into SMARTY plugins. Please care for correct prototype typing!
 */
interface isys_smarty_plugin
{
    /**
     * Defines wheather the sm2 meta map is enabled or not
     *
     * @return mixed
     */
    public function enable_meta_map();

    /**
     * Method for navigation-view.
     *
     * @param  isys_component_template $p_tplclass
     * @param  array                   $p_param
     */
    public function navigation_view(isys_component_template $p_tplclass, $p_param = null);

    /**
     * Method for navigation-edit.
     *
     * @param   isys_component_template &$p_tplclass
     * @param   array                   $p_param
     *
     * @return  string
     */
    public function navigation_edit(isys_component_template $p_tplclass, $p_params = null);

    /**
     * Method for retrieving the meta map.
     *
     * @return array
     */
    public static function get_meta_map();
} // class