<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
/**
 * i-doit
 *
 * Update checker
 *
 * @package     i-doit
 * @subpackage  General
 * @author      Dennis Stuecken <dstuecken@i.doit.org>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 *
 */
use idoit\Console\Command\Idoit\UpdateCheckCommand;
use idoit\Console\IdoitConsoleApplication;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\ConsoleOutput;

/**
 * Class isys_handler_updatecheck
 */
class isys_handler_updatecheck extends isys_handler
{
    /**
     * Init method.
     *
     * @return  boolean
     */
    public function init()
    {
        $application = new IdoitConsoleApplication();
        $application->setAutoExit(false);

        $output = new ConsoleOutput();

        $output->writeln('<error>isys_handler_updatecheck is deprecated, please use php console.php system-checkforupdates instead</error>');

        $commandParams = [
            'command' => 'system-checkforupdates'
        ];

        /**
         * @var $command \idoit\Console\Command\AbstractCommand
         */
        $command = new UpdateCheckCommand();
        $command->setContainer(\isys_application::instance()->container);

        $application->add($command);

        $application->run(new ArrayInput($commandParams), $output);

        return true;
    } // function

    /**
     *
     * @return  boolean
     */
    public function needs_login()
    {
        return false;
    } // function
} // class
