<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
namespace idoit\Component\ClassLoader;

use Symfony\Component\ClassLoader\MapClassLoader as SymfonyMapClassLoader;

/**
 * i-doit classmap loader
 *
 * @package     idoit\Component
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 *
 */
class MapClassLoader extends SymfonyMapClassLoader
{
    /**
     * @var string
     */
    protected $basePath = '';

    /**
     * @var array
     */
    protected $map = [];

    /**
     * @param array  $map
     * @param string $basePath
     *
     * @return MapClassLoader
     */
    public static function factory(array $map, $basePath = '')
    {
        return new self($map, $basePath);
    }

    /**
     * Constructor.
     *
     * @param array  $map      A map where keys are classes and values the absolute file path
     * @param string $basePath Root directory
     */
    public function __construct(array $map, $basePath = '')
    {
        $this->map = $map;

        if (file_exists($basePath))
        {
            $this->basePath = $basePath;
        }
    }

    /**
     * Loads the given class or interface.
     *
     * @param string $class The name of the class
     * @return bool
     */
    public function loadClass($class)
    {
        if (isset($this->map[$class]) && file_exists($this->basePath . $this->map[$class]))
        {
            require $this->basePath . $this->map[$class];

            return true;
        }

        return false;
    }

}
