<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
namespace idoit\Component\Factory;

use idoit\Component\Settings\DbSystem;
use Latitude\QueryBuilder\QueryFactory as LatitudeQueryFactory;

/**
 * i-doit Static DbSystem setting component
 *
 * @package     idoit\Component
 * @author      atsapko
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

class QueryFactory
{
    /**
     * @param DbSystem $dbConfig
     * @param bool     $identifier
     *
     * @return LatitudeQueryFactory
     */
    public static function factory($dbConfig, $identifier = false)
    {
        return new LatitudeQueryFactory($dbConfig->get('type'), $identifier);
    }
}