<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
namespace idoit\Component\Provider;

use idoit\Component\ContainerFacade;

/**
 * i-doit Container Aware Factory Trait
 *
 * @package     i-doit
 * @subpackage  Component
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
trait DiFactory
{
    use DiInjectable;

    /**
     * Factory with $container parameter
     *
     * @param ContainerFacade $container
     *
     * @return static
     */
    public static function factory(ContainerFacade $container)
    {
        $instance = new self();

        if (method_exists($instance, 'setDi'))
        {
            $instance->setDi($container);
        }

        return $instance;
    }

}