<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
/**
 *
 *
 * @package     i-doit
 * @subpackage
 * @author      Pavel Abduramanov <pabduramanov@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

namespace idoit\Component\Table\Filter\Condition;

/**
 * Checks, if the value in the predefined list of names
 *
 * @package idoit\Component\Table\Filter\Condition
 */
class InArrayCondition implements ConditionInterface
{
    /**
     * @var array
     */
    private $allowedNames;

    /**
     * InArrayCondition constructor.
     *
     * @param array $allowedNames
     */
    public function __construct(array $allowedNames = [])
    {
        $this->allowedNames = $allowedNames;
    }

    /**
     * @param string $name
     *
     * @return bool
     */
    public function check($name)
    {
        return in_array($name, $this->allowedNames);
    }
}
