<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
/**
 *
 *
 * @package     i-doit
 * @subpackage
 * @author      Pavel Abduramanov <pabduramanov@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

namespace idoit\Component\Table\Filter\Condition;

/**
 * Inverse the result of inner condition
 *
 * @package idoit\Component\Table\Filter\Condition
 */
class NotCondition implements ConditionInterface
{
    /**
     * @var ConditionInterface
     */
    private $condition;

    /**
     * NotCondition constructor.
     *
     * @param ConditionInterface $condition inner condition
     */
    public function __construct(ConditionInterface $condition)
    {
        $this->condition = $condition;
    }

    /**
     * @param string $value
     *
     * @return bool
     */
    public function check($value)
    {
        return !$this->condition->check($value);
    }
}
