<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
/**
 *
 *
 * @package     i-doit
 * @subpackage
 * @author      Pavel Abduramanov <pabduramanov@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

namespace idoit\Component\Table\Filter\Source;

/**
 * Get query source
 *
 * @package idoit\Component\Table\Filter\Source
 */
class QueryMapSource implements SourceInterface
{
    private $map = [];

    public function add($name, $value)
    {
        $this->map[$name] = $value;
    }

    /**
     * Gets the stored data
     *
     * @return Array
     */
    public function get()
    {
        $filter = [];
        foreach ($this->map as $k => $v) {
            if (isset($_GET[$k], $_GET[$v])) {
                $filter[$_GET[$k]] = $_GET[$v];
            }
        }
        return $filter;
    }
}
