<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
/**
 *
 *
 * @package     i-doit
 * @subpackage
 * @author      Pavel Abduramanov <pabduramanov@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

namespace idoit\Component\Table\Filter\Source;

/**
 * Get query source
 *
 * @package idoit\Component\Table\Filter\Source
 */
class QuerySource implements SourceInterface
{
    /**
     * Parameter name
     * @var string
     */
    private $parameterName;

    public function __construct($parameterName)
    {
        $this->parameterName = $parameterName;
    }

    /**
     * Gets the stored data
     *
     * @return Array
     */
    public function get()
    {
        if (isset($_GET[$this->parameterName]) && is_array($_GET[$this->parameterName]))
        {
            return $_GET[$this->parameterName];
        }
        return [];
    }
}
