<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
/**
 *
 *
 * @package     i-doit
 * @subpackage
 * @author      Pavel Abduramanov <pabduramanov@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

namespace idoit\Component\Table\Filter\Source;

/**
 * Fetches the filters from different sources
 *
 * @package idoit\Component\Table\Filter\Source
 */
class SourceProvider
{
    /**
     * @var array<SourceInterface>
     */
    protected $sources = [];

    /**
     * Add source
     * @param SourceInterface $source
     */
    public function addSource(SourceInterface $source)
    {
        $this->sources[] = $source;
    }

    /**
     * Fetch parameters from sources till found
     * @return array
     */
    public function fetch()
    {
        foreach ($this->sources as $source)
        {
            if ($source instanceof SourceInterface)
            {
                $filters = $source->get();
                if (is_array($filters) && count($filters) > 0)
                {
                    return $filters;
                }
            }
        }

        return [];
    }
}
