<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
/**
 *
 *
 * @package     i-doit
 * @subpackage
 * @author      Pavel Abduramanov <pabduramanov@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

namespace idoit\Component\Table\Filter\Source;

use idoit\Module\Cmdb\Model\Ci\Table\Config;

class TableConfigDefaultsSource implements SourceInterface
{
    /**
     * @var Config
     */
    private $tableConfig;

    public function __construct(Config $tableConfig)
    {
        $this->tableConfig = $tableConfig;
    }

    /**
     * Gets the stored data
     *
     * @return Array
     */
    public function get()
    {
        $filters = [];
        $filterValue = $this->tableConfig->getFilterValue();
        $filterField = $this->tableConfig->getFilterProperty();
        if ($filterField && !is_array($filterField) && $filterValue && !is_array($filterValue))
        {
            $filters[$filterField] = $filterValue;
        }

        return $filters;
    }
}