<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

namespace idoit\Console\Command\Import\Csv;

use idoit\Console\Command\AbstractCommand;
use isys_module_import_csv;
use Symfony\Component\Console\Input\InputDefinition;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class ListProfilesCommand extends AbstractCommand
{
    const NAME = 'import-csvprofiles';

    /**
     * Get name for command
     *
     * @return string
     */
    public function getCommandName()
    {
        return self::NAME;
    }

    /**
     * Get description for command
     *
     * @return string
     */
    public function getCommandDescription()
    {
        return 'List all available csv profiles';
    }

    /**
     * Retrieve Command InputDefinition
     *
     * @return InputDefinition
     */
    public function getCommandDefinition()
    {
        $definition = new InputDefinition();
        return $definition;
    }

    /**
     * Checks if a command can have a config file via --config
     *
     * @return bool
     */
    public function isConfigurable()
    {
        return false;
    }

    /**
     * Returns an array of command usages
     *
     * @return string[]
     */
    public function getCommandUsages()
    {
        return [];
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $l_profiles = isys_module_import_csv::get_profiles();

        if (is_array($l_profiles) && count($l_profiles))
        {
            $output->writeln('List of profiles:');

            foreach ($l_profiles AS $l_profile)
            {
                $output->writeln(str_pad($l_profile['id'], 5, ' ', STR_PAD_LEFT) . ': ' . $l_profile['title']);
            } // foreach
        }
        else
        {
            $output->writeln('<error>Attention: No profiles found! You need to provide at least one profile to import a CSV file! Please create one using the CSV import GUI.</error>');
        } // if
    }
}
