<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

namespace idoit\Console\Command\Import;

use isys_cmdb_dao;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class ImportInventoryCommand extends AbstractImportCommand
{
    const NAME = 'import-hinventory';

    public function getCommandDescription()
    {
        return 'Imports files formatted in the hInventory XML syntax';
    }

    public function getImportHandler()
    {
        return 'inventory';
    }

    public function getCommandDefinition()
    {
        $definition = parent::getCommandDefinition(); // TODO: Change the autogenerated stub

        $definition->addOption(new InputOption(
            'objectType',
            null,
            InputOption::VALUE_REQUIRED,
            'Import by given object type'
        ));

        $definition->addOption(new InputOption(
            'objectId',
            null,
            InputOption::VALUE_REQUIRED,
            'Import only given object'
        ));

        $definition->addOption(new InputOption(
            'force',
            'f',
            InputOption::VALUE_NONE,
            'Force enables updating of existing objects/imports, but overwrites the imported categories'
        ));

        return $definition;
    }

    /**
     * Prints out the usage of the import handler
     *
     * @param OutputInterface $output
     */
    protected function usage(OutputInterface $output)
    {
        $output->writeln("<comment>Usage:</comment>");
        $output->writeln("  import-hinventory --importFile inventory-export.xml [--objectType] [--objectId] [--force]");
        $output->writeln('');
        $output->writeln("  Example for importing a client with an inventory xml export:");
        $output->writeln("  import-hinventory --importFile imports/client_1.xml --objectType=10 --force");
        $output->writeln('');
        $output->writeln("  --force: Force enables updating of existing objects/imports, but overwrites the imported categories.");

        $output->writeln('');
        $output->writeln("  Object Types:");

        $output->writeln("  <info>ID  Object-Type</info>");

        $l_dao    = new isys_cmdb_dao($this->container->database);
        $l_otypes = $l_dao->get_types();
        while ($l_row = $l_otypes->get_row())
        {

            $output->writeln('  ' . $l_row["isys_obj_type__id"] . ":  " . $l_row["isys_obj_type__const"]);

        }
    }
}
