<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

namespace idoit\Console\Command;

use idoit\Console\Exception\InvalidCredentials;
use Symfony\Component\Console\Input\InputInterface;

interface LoginAwareInterface
{
    /**
     * Login an user with User, Password and tenantId as requirements
     *
     * @param InputInterface $input
     *
     * @return bool
     *
     * @throws InvalidCredentials
     */
    public function login(InputInterface $input);

    /**
     * Logout an user
     *
     * @return boolean
     */
    public function logout();

    /**
     * Requires command login via session ?
     *
     * @return boolean
     */
    public function requiresLogin();
}
