<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
namespace idoit\Model;

/**
 * i-doit Breadcrumb Model
 *
 * @package     i-doit
 * @subpackage  Core
 * @author      Dennis Stücken <dstuecken@synetics.de>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
abstract class Model
{

    /**
     * Assign raw data array into class properties
     *
     * $row should be something like [
     *   'isys_obj_type__id' => 1,
     *   'isys_obj_type__title' => 'Title'
     * ];
     *
     * @param array $row
     */
    public function assignRawData(array $row)
    {
        foreach ($this->columnMap() as $classProp => $dbValue)
        {
            if (isset($row[$dbValue]))
            {
                $this->$classProp = $row[$dbValue];
            }
        }
    }

    /**
     * Return current model as array, according to a column map, if provided.
     *
     * @return array
     */
    public function toArray($columnMap = [])
    {
        $return = [];
        foreach (get_object_vars($this) as $key => $value)
        {

            if (isset($columnMap[$key]))
            {
                $return[$columnMap[$key]] = $value;
            }
            else
            {
                $return[$key] = $value;
            }

        }

        return $return;
    }

    /**
     * Defines a column map for raw data associations
     *
     * Exmaple: [
     * 'id' => 'isys_obj_type__id',
     * 'title' => 'isys_obj_type__title'
     * ];
     *
     * @return array
     */
    public function columnMap()
    {
        return [];
    }

}
