<?php
/**
 * i-doit
 *
 * Global definitions.
 *
 * This file provides basic functionalities needed by all source files.
 *
 * @package     i-doit
 * @subpackage  General
 * @author      Andre Woesten <awoesten@i-doit.de>
 * @version     Dennis Stücken <dstuecken@i-doit.de>
 * @version     1.5
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
include_once('version.inc.php');

// Get localization class
include_once __DIR__ . '/locales.inc.php';

// Include global functions.
include_once("functions.inc.php");

// Include global constants.
include_once("constants.inc.php");

global $g_absdir;

$g_config = [
    "base_dir"      => $g_absdir . DIRECTORY_SEPARATOR,
    "www_dir"       => str_replace('src/jsonrpc.php', '', str_replace('index.php', '', @$_SERVER['SCRIPT_NAME'])),
    "theme"         => "default",
    "startpage"     => "index.php",
    "html-encoding" => "utf-8"
];

// Initialize global directory configuration
if (!isset($g_dirs)) {
    $g_dirs = [];
}

// Global error/exception message.
$g_error = "";

// Internal smarty/template config.
$g_template = [
    "start_page" => "main.tpl",
    "ajax"       => "ajax.tpl"
];

// Include autoloader
include_once("autoload.inc.php");

// Include convert class
include_once("convert.inc.php");

// Get global converter.
$g_convert = new isys_convert();

// If this is set to true, there is no template display at all
$g_output_done = false;

// Including isys_application
include_once(__DIR__ . '/classes/core/isys_application.class.php');

// Call bootstrapping and load all required components
isys_application::instance()
    ->language(isset($_GET["lang"]) ? $_GET["lang"] : null)
    ->bootstrap();
