<?php

use idoit\Console\IdoitConsoleApplication;
use idoit\Module\Check_mk\Console\Command\CheckMkCommand;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\ConsoleOutput;

/**
 * Controller for writing status changes to the Logbook.
 *
 * @package     Modules
 * @subpackage  Check_MK
 * @author      Leonard Fischer <lfischer@i-doit.org>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.0
 */
class isys_handler_check_mk extends isys_handler
{
    /**
     * Initialization method.
     *
     * @global  isys_component_session  $g_comp_session
     * @global  isys_component_database $g_comp_database
     * @return  boolean
     */
    public function init()
    {
        global $g_comp_session;

        if ($g_comp_session->is_logged_in()) {
            $application = new IdoitConsoleApplication();
            $application->setAutoExit(false);

            $output = new ConsoleOutput();

            $output->writeln('<error>isys_handler_check_mk is deprecated, please use php console.php check_mk-status2logbook instead</error>');

            $commandParams = [
                'command'    => 'check_mk-status2logbook',
                '--user'     => 'loginBefore',
                '--password' => 'loginBefore',
                '--tenantId' => 'loginBefore'
            ];

            /**
             * @var $command \idoit\Console\Command\AbstractCommand
             */
            $command = new CheckMkCommand();
            $command->setSession($g_comp_session);
            $command->setContainer(\isys_application::instance()->container);
            $command->setAuth(\isys_auth_system::instance());

            $application->add($command);

            $application->run(new ArrayInput($commandParams), $output);
        }

        return false;
    }
}
