<?php

/**
 * i-doit
 *
 * DAO: specific category for file objects.
 *
 * @package     i-doit
 * @subpackage  CMDB_Categories
 * @author      Dennis Stücken <dstuecken@i-doit.org>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_dao_category_s_file_object extends isys_cmdb_dao_category_s_file
{
    /**
     * Category's name. Will be used for the identifier, constant, main table, and many more.
     *
     * @var  string
     */
    protected $m_category = 'file_object';

    /**
     * Category's constant.
     *
     * @var  string
     */
    protected $m_category_const = 'C__CATS__FILE_OBJECTS';

    /**
     * Category's table
     *
     * @var string
     */
    protected $m_table = 'isys_cats_file_list';

    /**
     * Category's template.
     *
     * @var  string
     */
    protected $m_tpl = 'object_table_list.tpl';

    /**
     * Method for returning the properties.
     *
     * @return  array
     */
    protected function properties()
    {
        return [
            'assigned_objects' => array_replace_recursive(isys_cmdb_dao_category_pattern::object_browser(), [
                C__PROPERTY__INFO     => [
                    C__PROPERTY__INFO__TITLE       => 'LC__CATS__CMDB__FILE__OBJECTS',
                    C__PROPERTY__INFO__DESCRIPTION => 'Assigned objects'
                ],
                C__PROPERTY__DATA     => [
                    C__PROPERTY__DATA__SELECT => idoit\Module\Report\SqlQuery\Structure\SelectSubSelect::factory('SELECT
                                (CASE
                                    WHEN isys_catg_file_list__id IS NOT NULL THEN CONCAT(file_assignment.isys_obj__title, \' {\', file_assignment.isys_obj__id, \'}\')
                                    WHEN isys_catg_manual_list__id IS NOT NULL THEN CONCAT(manual_assignment.isys_obj__title, \' {\', manual_assignment.isys_obj__id, \'}\')
                                    WHEN isys_catg_emergency_plan_list__id IS NOT NULL THEN CONCAT(ep_assignment.isys_obj__title, \' {\', ep_assignment.isys_obj__id, \'}\')
                                END)
                                FROM isys_connection
                                LEFT JOIN isys_catg_file_list ON isys_catg_file_list__isys_connection__id = isys_connection__id
                                LEFT JOIN isys_obj AS file_assignment ON file_assignment.isys_obj__id = isys_catg_file_list__isys_obj__id
                                LEFT JOIN isys_catg_manual_list ON isys_catg_manual_list__isys_connection__id = isys_connection__id
                                LEFT JOIN isys_obj AS manual_assignment ON manual_assignment.isys_obj__id = isys_catg_manual_list__isys_obj__id
                                LEFT JOIN isys_catg_emergency_plan_list ON isys_catg_emergency_plan_list__isys_connection__id = isys_connection__id
                                LEFT JOIN isys_obj AS ep_assignment ON ep_assignment.isys_obj__id = isys_catg_emergency_plan_list__isys_obj__id', 'isys_connection',
                        'isys_connection__id', 'isys_connection__isys_obj__id', '', '',
                        \idoit\Module\Report\SqlQuery\Structure\SelectCondition::factory(['(isys_catg_file_list__id > 0 OR isys_catg_manual_list__id > 0 OR isys_catg_emergency_plan_list__id > 0)']),
                        \idoit\Module\Report\SqlQuery\Structure\SelectGroupBy::factory(['isys_connection__isys_obj__id']))
                ],
                C__PROPERTY__UI => [
                    C__PROPERTY__UI__ID => 'C__CATS__CMDB__FILE__OBJECTS'
                ],
                C__PROPERTY__PROVIDES => [
                    C__PROPERTY__PROVIDES__SEARCH     => false,
                    C__PROPERTY__PROVIDES__REPORT     => false,
                    C__PROPERTY__PROVIDES__VIRTUAL    => true,
                    C__PROPERTY__PROVIDES__EXPORT     => false,
                    C__PROPERTY__PROVIDES__IMPORT     => false,
                    C__PROPERTY__PROVIDES__MULTIEDIT  => false,
                    C__PROPERTY__PROVIDES__VALIDATION => false,
                    C__PROPERTY__PROVIDES__LIST       => true
                ],
            ])
        ];
    }

    /**
     * Method for retrieving the number of objects, assigned to an object.
     *
     * @param   integer $p_obj_id
     *
     * @return  integer
     */
    public function get_count($p_obj_id = null)
    {
        if ($p_obj_id !== null) {
            $l_obj_id = $p_obj_id;
        } else {
            $l_obj_id = $this->m_object_id;
        }

        $l_sql = "SELECT count(isys_obj__id) AS count FROM isys_obj " . "LEFT JOIN isys_connection ON isys_connection__isys_obj__id = isys_obj__id " .
            "LEFT JOIN isys_catg_manual_list ON isys_catg_manual_list__isys_connection__id = isys_connection__id " .
            "LEFT JOIN isys_catg_file_list ON isys_catg_file_list__isys_connection__id = isys_connection__id " .
            "LEFT JOIN isys_catg_emergency_plan_list ON isys_catg_emergency_plan_list__isys_connection__id = isys_connection__id " .
            "WHERE (isys_catg_manual_list__id IS NOT NULL OR isys_catg_file_list__id IS NOT NULL OR isys_catg_emergency_plan_list__id IS NOT NULL) ";

        if ($l_obj_id !== null) {
            $l_sql .= "AND (isys_obj__id = " . $this->convert_sql_id($l_obj_id) . ") ";
        }

        return (int)$this->retrieve($l_sql)
            ->get_row_value('count');
    }

    /**
     * Get data method.
     *
     * @param   integer $p_catg_list_id
     * @param   integer $p_obj_id
     * @param   string  $p_condition
     * @param   array   $p_filter
     * @param   integer $p_status
     *
     * @return  isys_component_dao_result
     */
    public function get_data($p_catg_list_id = null, $p_obj_id = null, $p_condition = '', $p_filter = null, $p_status = null)
    {
        $p_condition .= $this->prepare_filter($p_filter);

        $l_sql = "SELECT * FROM isys_obj " . "LEFT JOIN isys_connection ON isys_connection__isys_obj__id = isys_obj__id " .
            "LEFT JOIN isys_cats_file_list ON isys_cats_file_list__isys_obj__id = isys_obj__id " .
            "LEFT JOIN isys_file_version ON isys_file_version__id = isys_cats_file_list__isys_file_version__id " .
            "LEFT JOIN isys_catg_manual_list ON isys_catg_manual_list__isys_connection__id = isys_connection__id " .
            "LEFT JOIN isys_catg_file_list ON isys_catg_file_list__isys_connection__id = isys_connection__id " .
            "LEFT JOIN isys_catg_emergency_plan_list ON isys_catg_emergency_plan_list__isys_connection__id = isys_connection__id " . "WHERE TRUE " . $p_condition . " ";

        $l_sql .= "AND (isys_catg_manual_list__id IS NOT NULL OR isys_catg_file_list__id IS NOT NULL OR isys_catg_emergency_plan_list__id IS NOT NULL) ";

        if ($p_obj_id !== null) {
            $l_sql .= $this->get_object_condition($p_obj_id);
        }

        if ($p_status !== null) {
            $l_sql .= " AND (isys_obj__status = " . $this->convert_sql_int($p_status) . ") ";
        }

        return $this->retrieve($l_sql);
    }

    /**
     * Verifiy posted data, save set_additional_rules and validation state for further usage.
     *
     * @param array $p_data
     * @param mixed $p_prepend_table_field
     *
     * @return  boolean
     */
    public function validate(array $p_data = [], $p_prepend_table_field = false)
    {
        return true;
    }

    /**
     * Verifiy posted data, save set_additional_rules and validation state for further usage.
     *
     * @return  boolean
     */
    public function validate_user_data()
    {
        return true;
    }
}