<?php

/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @version     1.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_custom_fields_autoload extends isys_module_manager_autoload
{
    /**
     * Autoloader.
     *
     * @param   string $p_classname
     *
     * @return  boolean
     * @throws  Exception
     */
    public static function init($p_classname)
    {
        try {
            if ($p_classname === 'isys_custom_fields_dao') {
                if (parent::include_file(($l_path = '/src/classes/modules/custom_fields/dao/isys_custom_fields_dao.class.php'))) {
                    isys_caching::factory('autoload')
                        ->set($p_classname, $l_path);

                    return true;
                }
            }
        } catch (Exception $e) {
            throw $e;
        }

        return false;
    }
}