<?php
/**
 * i-doit
 *
 * Module initializer
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @version     1.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

if (include_once('isys_module_jdisc_autoload.class.php')) {
    spl_autoload_register('isys_module_jdisc_autoload::init');
}

/* Register jdisc controller */
$GLOBALS['g_controller']['handler']['jdisc'] = [
    'class' => 'isys_handler_jdisc'
];
/* Register jdisc controller */
$GLOBALS['g_controller']['handler']['jdisc_discovery'] = [
    'class' => 'isys_handler_jdisc_discovery'
];

// Handle module specific language files.
global $g_idoit_language_short;

if (file_exists(__DIR__ . '/lang/' . $g_idoit_language_short . '.inc.php')) {
    $l_language = include_once 'lang/' . $g_idoit_language_short . '.inc.php';

    if (is_array($l_language)) {
        isys_application::instance()->container->get('language')
            ->append_lang($l_language);
    }
}

\idoit\Psr4AutoloaderClass::factory()
    ->addNamespace('idoit\Module\JDisc', __DIR__ . '/src/');
