<?php

/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @version     1.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_jdisc_autoload extends isys_module_manager_autoload
{
    /**
     * Autoloader
     *
     * @param   string $p_classname
     *
     * @return  boolean
     */
    public static function init($p_classname)
    {
        if (strpos($p_classname, 'isys_jdisc_dao') === 0) {
            if (parent::include_file(($l_path = '/src/classes/modules/jdisc/dao/' . $p_classname . '.class.php'))) {
                isys_caching::factory('autoload')
                    ->add($p_classname, $l_path);

                return true;
            }
        }
        if (strpos($p_classname, 'isys_cmdb_dao_jdisc') === 0) {
            if (parent::include_file(($l_path = '/src/classes/modules/jdisc/cmdb/dao/' . $p_classname . '.class.php'))) {
                isys_caching::factory('autoload')
                    ->add($p_classname, $l_path);

                return true;
            }
        }
        if (strpos($p_classname, 'isys_ajax_handler_jdisc') === 0) {
            if (parent::include_file(($l_path = '/src/classes/modules/jdisc/handler/ajax/' . $p_classname . '.class.php'))) {
                isys_caching::factory('autoload')
                    ->add($p_classname, $l_path);

                return true;
            }
        }
        if (strpos(' ' . $p_classname, 'isys_handler_jdisc')) {
            if (parent::include_file(($l_path = '/src/classes/modules/jdisc/handler/controller/' . $p_classname . '.class.php'))) {
                isys_caching::factory('autoload')
                    ->add($p_classname, $l_path);

                return true;
            }
        }
        if ($p_classname == 'isys_popup_duplicate_jdisc_profile') {
            if (parent::include_file(($l_path = '/src/classes/modules/jdisc/popups/' . $p_classname . '.class.php'))) {
                isys_caching::factory('autoload')
                    ->add($p_classname, $l_path);

                return true;
            }
        }

        if (strpos(' ' . $p_classname, 'isys_cmdb_dao_category_g_jdisc_')) {
            $l_path = '/src/classes/modules/jdisc/cmdb/dao/global/' . $p_classname . '.class.php';
            if (parent::include_file(($l_path))) {
                isys_caching::factory('autoload')
                    ->add($p_classname, $l_path);

                return true;
            }
        }

        if (strpos(' ' . $p_classname, 'isys_cmdb_dao_list_catg_jdisc_')) {
            $l_path = '/src/classes/modules/jdisc/cmdb/dao/list/' . $p_classname . '.class.php';
            if (parent::include_file(($l_path))) {
                isys_caching::factory('autoload')
                    ->add($p_classname, $l_path);

                return true;
            }
        }

        if (strpos(' ' . $p_classname, 'isys_cmdb_ui_category_g_jdisc_')) {
            $l_path = '/src/classes/modules/jdisc/cmdb/ui/global/' . $p_classname . '.class.php';
            if (parent::include_file(($l_path))) {
                isys_caching::factory('autoload')
                    ->add($p_classname, $l_path);

                return true;
            }
        }

        return false;
    }
}