<?php

/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.3.0
 */
class isys_module_monitoring_autoload extends isys_module_manager_autoload
{
    /**
     * Module specific autoloader.
     *
     * @param   string $classname
     *
     * @return  boolean
     * @throws  Exception
     */
    public static function init($classname)
    {
        $base = '/src/classes/modules/monitoring/';

        $classmap = [
            'isys_api_model_monitoring'               => 'api/isys_api_model_monitoring.class.php',
            'isys_api_model_monitoring_livestatus'    => 'api/isys_api_model_monitoring_livestatus.class.php',
            'isys_api_model_monitoring_ndo'           => 'api/isys_api_model_monitoring_ndo.class.php',
            'isys_monitoring_dao_hosts'               => 'dao/isys_monitoring_dao_hosts.class.php',
            'isys_monitoring_dao_ndo'                 => 'dao/isys_monitoring_dao_ndo.class.php',
            'isys_ajax_handler_monitoring_livestatus' => 'handler/ajax/isys_ajax_handler_monitoring_livestatus.class.php',
            'isys_ajax_handler_monitoring_ndo'        => 'handler/ajax/isys_ajax_handler_monitoring_ndo.class.php',
            'isys_monitoring_helper'                  => 'helper/isys_monitoring_helper.class.php',
            'isys_monitoring_livestatus'              => 'livestatus/isys_monitoring_livestatus.class.php',
            'isys_monitoring_ndo'                     => 'ndo/isys_monitoring_ndo.class.php',
            'isys_monitoring_widgets_not_ok_hosts'    => 'widgets/not_ok_hosts/isys_monitoring_widgets_not_ok_hosts.class.php'
        ];

        if (isset($classmap[$classname])) {
            if (parent::include_file($base . $classmap[$classname])) {
                isys_caching::factory('autoload')->set($classname, $base . $classmap[$classname]);

                return true;
            }
        }

        return false;
    }
}