<?php

use idoit\Console\IdoitConsoleApplication;
use idoit\Module\Nagios\Console\Command\NagiosExportCommand;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\ConsoleOutput;

/**
 * i-doit
 *
 * Nagios Export handler
 *
 * @package     i-doit
 * @subpackage  General
 * @author      Dennis Blümer <dbluemer@i.doit.org>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_handler_nagios_export extends isys_handler
{
    /**
     * Initialization method.
     *
     * @return  boolean
     */
    public function init()
    {
        global $argv, $g_comp_session;

        if ($g_comp_session->is_logged_in()) {
            if (array_search("-h", $argv)) {
                $this->display_help();

                return true;
            }

            $application = new IdoitConsoleApplication();
            $application->setAutoExit(false);

            $output = new ConsoleOutput();

            $output->writeln('<error>isys_handler_nagios_export is deprecated, please use php console.php nagios-export instead</error>');

            $commandParams = [
                'command'    => 'nagios-export',
                '--user'     => 'loginBefore',
                '--password' => 'loginBefore',
                '--tenantId' => 'loginBefore'
            ];

            $l_key = array_search("-n", $argv);

            if (!(!is_numeric($l_key) || !$argv[++$l_key])) {
                $commandParams['--nagiosHostId'] = $argv[$l_key];
            }

            if (array_search("-validate", $argv)) {
                $commandParams['--validate'] = true;
            }

            /**
             * @var $command \idoit\Console\Command\AbstractCommand
             */
            $command = new NagiosExportCommand();
            $command->setSession($g_comp_session);
            $command->setContainer(\isys_application::instance()->container);
            $command->setAuth(\isys_auth_system::instance());

            $application->add($command);

            $application->run(new ArrayInput($commandParams), $output);
        }

        return true;
    }

    /**
     * Displays the help.
     */
    protected function display_help()
    {
        verbose('The nagios_export controller offers three options:');
        verbose(' -n <nagios host ID>  This will define, which nagios host shall be used for the export.');
        verbose(' -validate            This will activate the nagios export validation... Meaning, only valid objects will be exported');
        verbose(' -h                   This will display this help.');
    }
}
