<?php

/**
 * i-doit PRO
 *
 * Class autoloader.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Dennis Stücken <dstuecken@synetics.de>
 * @version     1.3
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_pro_autoload extends isys_module_manager_autoload
{
    /**
     * Autoloader
     *
     * @param   string $p_classname
     *
     * @return  boolean
     * @throws  Exception
     */
    public static function init($p_classname)
    {
        if (strpos($p_classname, 'isys_pro_') === 0) {
            $l_path = '/src/classes/modules/pro/' . $p_classname . '.class.php';
        } else if (strpos($p_classname, 'isys_cmdb_dao_category_s') === 0) {
            $l_path = '/src/classes/modules/pro/cmdb/dao/specific/' . $p_classname . '.class.php';
        } else if (strpos($p_classname, 'isys_cmdb_ui_category_s') === 0) {
            $l_path = '/src/classes/modules/pro/cmdb/ui/specific/' . $p_classname . '.class.php';
        } else if (strpos($p_classname, 'isys_cmdb_dao_category_g') === 0) {
            $l_path = '/src/classes/modules/pro/cmdb/dao/global/' . $p_classname . '.class.php';
        } else if (strpos($p_classname, 'isys_cmdb_ui_category_g') === 0) {
            $l_path = '/src/classes/modules/pro/cmdb/ui/global/' . $p_classname . '.class.php';
        } else if (strpos($p_classname, 'isys_cmdb_view') === 0) {
            $l_path = '/src/classes/modules/pro/cmdb/view/' . $p_classname . '.class.php';
        } else if (strpos($p_classname, 'isys_dashboard_widgets_') === 0) {
            $l_path = '/src/classes/modules/pro/dashboard/widgets/' . str_replace('_', DS, substr($p_classname, 23)) . DS . $p_classname . '.class.php';
        } else if (strpos($p_classname, 'isys_ajax_handler') === 0) {
            $l_path = '/src/classes/modules/pro/ajax/handler/' . $p_classname . '.class.php';
        } else if (strpos($p_classname, 'isys_visualization_export') === 0) {
            $l_path = '/src/classes/modules/pro/visualization/export/' . $p_classname . '.class.php';
        } else if (strpos($p_classname, 'isys_visualization_graph_visitor') === 0 || strpos($p_classname, 'isys_visualization_tree_visitor') === 0) {
            $l_path = '/src/classes/modules/pro/visualization/visitor/' . $p_classname . '.class.php';
        } else if (strpos($p_classname, 'isys_visualization_graph') === 0) {
            $l_path = '/src/classes/modules/pro/visualization/graph/' . $p_classname . '.class.php';
        } else if (strpos($p_classname, 'isys_visualization_profile') === 0) {
            $l_path = '/src/classes/modules/pro/visualization/profile/' . $p_classname . '.class.php';
        } else if (strpos($p_classname, 'isys_visualization_tree') === 0) {
            $l_path = '/src/classes/modules/pro/visualization/tree/' . $p_classname . '.class.php';
        } else if (strpos($p_classname, 'isys_visualization') === 0 || strpos($p_classname, 'isys_visualization_model') === 0) {
            $l_path = '/src/classes/modules/pro/visualization/' . $p_classname . '.class.php';
        } else if (strpos($p_classname, 'isys_popup_visualization_') === 0) {
            $l_path = '/src/classes/modules/pro/visualization/popup/' . $p_classname . '.class.php';
        } else if (strpos($p_classname, 'isys_popup_') === 0) {
            $l_path = '/src/classes/modules/pro/popup/' . $p_classname . '.class.php';
        }

        if (!empty($l_path) && parent::include_file($l_path)) {
            isys_caching::factory('autoload')
                ->set($p_classname, $l_path);

            return true;
        }

        return false;
    }
}