<?php

namespace idoit\Module\Pro\FlatTree;

/**
 * i-doit graph structure.
 *
 * @package     i-doit
 * @subpackage  General
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Tree extends \isys_tree
{
    /**
     * Convert tree structure into flat (!!) array.
     *
     * @return  array
     */
    public function toArray()
    {
        $root = $this->m_children[0];
        $return = [$root->get_data('id') => $root->get_data()];

        foreach ($root->all_nodes() as $nodeCollection) {
            $return[$nodeCollection->get_data('id')] = $nodeCollection->get_data();

            foreach ($nodeCollection->toArray() as $node) {
                $return[$node['id']] = $node;
            }
        }

        return array_values($return);
    }
}