<?php
/**
 * i-doit
 *
 * Module initializer
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @version     1.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

if (include_once('isys_module_quick_configuration_wizard_autoload.class.php')) {
    spl_autoload_register('isys_module_quick_configuration_wizard_autoload::init');
}

if (class_exists('\idoit\Psr4AutoloaderClass')) {
    \idoit\Psr4AutoloaderClass::factory()
        ->addNamespace('idoit\Module\QCW', __DIR__ . '/src/');
}

if (file_exists(__DIR__ . '/lang/' . isys_component_session::instance()
        ->get_language() . '.inc.php')) {
    $l_language = include_once __DIR__ . '/lang/' . isys_component_session::instance()
            ->get_language() . '.inc.php';

    if (is_array($l_language)) {
        isys_application::instance()->container->get('language')
            ->append_lang($l_language);
    }
}
