<?php

/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @version     1.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_report_autoload extends isys_module_manager_autoload
{
    /**
     * Autoloader.
     *
     * @param   string $p_classname
     *
     * @return  boolean
     */
    public static function init($p_classname)
    {
        $l_classmap = [
            'isys_report_dao'           => '/src/classes/modules/report/dao/isys_report_dao.class.php',
            'isys_module_report_open'   => '/src/classes/modules/report/controller/isys_module_report_open.class.php',
            'isys_module_report_pro'    => '/src/classes/modules/report/controller/isys_module_report_pro.class.php',
            'isys_auth_report'          => '/src/classes/modules/report/auth/isys_auth_report.class.php',
            'isys_auth_dao_report'      => '/src/classes/modules/report/auth/dao/isys_auth_dao_report.class.php',
            'isys_ajax_handler_report'  => '/src/classes/modules/report/handler/ajax/isys_ajax_handler_report.class.php',
            'isys_handler_report'       => '/src/classes/modules/report/handler/controller/isys_handler_report.class.php',
            'isys_popup_report'         => '/src/classes/modules/report/popups/isys_popup_report.class.php',
            'isys_popup_report_browser' => '/src/classes/modules/report/popups/isys_popup_report_browser.class.php',
            'isys_report_export_fpdi'   => '/src/classes/modules/report/export/isys_report_export_fpdi.class.php',
        ];

        if (isset($l_classmap[$p_classname])) {
            $l_path = $l_classmap[$p_classname];
        } else {
            if (strpos($p_classname, 'isys_report_view') === 0) {
                $l_path = '/src/classes/modules/report/views/' . $p_classname . '.class.php';
            } elseif (strpos($p_classname, 'isys_report_') === 0) {
                $l_path = '/src/classes/modules/report/' . str_replace('_', DS, substr($p_classname, 12)) . DS . $p_classname . '.class.php';
            } elseif (strpos($p_classname, 'isys_dashboard_') === 0) {
                $l_path = '/src/classes/modules/report/dashboard/widgets/reports/' . $p_classname . '.class.php';
            }
        }

        if (!empty($l_path)) {
            if (parent::include_file($l_path)) {
                isys_caching::factory('autoload')
                    ->set($p_classname, $l_path);

                return true;
            }
        }

        return false;
    }
}
