<?php

/**
 * i-doit Report Manager View
 *
 * @package     i-doit
 * @subpackage  Reports
 * @author      Leonard Fischer <lfischer@i-doit.org>
 * @copyright   Copyright 2011 - synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       0.9.9-8
 */
class isys_report_view_accounting extends isys_report_view
{
    /**
     * Method for ajax-requests. Must be implemented.
     *
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public function ajax_request()
    {
        ;
    }

    /**
     * Method for retrieving the language constant of the report-description.
     *
     * @return  string
     * @author  Leonard Fischer <lfischer@i-doit.org>
     * @todo    Should we update the parent method to retrieve this automatically?
     */

    public static function description()
    {
        return 'Report zum darstellen der geänderten Kostenstellen innerhalb eines Zeitraums';
    }

    /**
     * Initialize method.
     *
     * @return  boolean
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public function init()
    {
        return true;
    }

    /**
     * Method for retrieving the language constant of the report-name.
     *
     * @return  string
     * @author  Leonard Fischer <lfischer@i-doit.org>
     * @todo    Should we update the parent method to retrieve this automatically?
     */
    public static function name()
    {
        return 'Buchhaltung Kostenstellen';
    }

    /**
     * Start-method - Implement the logic for displaying your data here.
     *
     * @global  isys_component_database $g_comp_database
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public function start()
    {
        global $g_comp_database, $g_dirs;

        // Preparing some variables.
        $l_return = [];

        if ($_POST['C__CALENDAR_FROM__HIDDEN'] && $_POST['C__CALENDAR_TO__HIDDEN']) {
            // Initializing the DAO's.
            $l_log_dao = new isys_component_dao_logbook($g_comp_database);
            $l_from = date('Y-m-d', strtotime($_POST['C__CALENDAR_FROM__HIDDEN']));
            $l_to = date('Y-m-d', strtotime($_POST['C__CALENDAR_TO__HIDDEN']));

            // Prepare the SQL to select all entries from "accounting" between the given dates.
            $l_sql = "SELECT * FROM isys_logbook
				LEFT JOIN isys_catg_logb_list ON isys_catg_logb_list__isys_logbook__id = isys_logbook__id
				LEFT JOIN isys_obj ON isys_obj__id = isys_catg_logb_list__isys_obj__id
                LEFT JOIN isys_catg_model_list ON isys_catg_model_list__isys_obj__id = isys_catg_logb_list__isys_obj__id
				WHERE (isys_logbook__date BETWEEN '" . $l_from . "' AND '" . $l_to . "')
				AND (isys_logbook__category_static = 'LC__CMDB__CATG__ACCOUNTING');";

            $l_res = $l_log_dao->retrieve($l_sql);

            while ($l_row = $l_res->get_row()) {
                $l_changes = unserialize($l_row['isys_logbook__changes']);

                if (is_array($l_changes)) {
                    if (isset($l_changes['isys_cmdb_dao_category_g_accounting::account']) || isset($l_changes['C__CATG__ACCOUNTING__ACCOUNT'])) {
                        $l_change_from = $l_changes['isys_cmdb_dao_category_g_accounting::account']['from'] ?: $l_changes['C__CATG__ACCOUNTING__ACCOUNT']['from'];
                        $l_change_to = $l_changes['isys_cmdb_dao_category_g_accounting::account']['to'] ?: $l_changes['C__CATG__ACCOUNTING__ACCOUNT']['to'];

                        if ($l_change_from === null) {
                            $l_change_from = '<i>leer</i>';
                        }

                        if ($l_change_to === null) {
                            $l_change_to = '<i>leer</i>';
                        }

                        $l_return[] = [
                            $l_row['isys_obj__id'],
                            '<a href="?' . C__CMDB__GET__OBJECT . '=' . $l_row['isys_obj__id'] . '&' . C__CMDB__GET__CATG . '=' . C__CATG__ACCOUNTING . '">' .
                            isys_application::instance()->container->get('language')
                                ->get($l_row['isys_logbook__obj_type_static']) . ' &raquo; ' . $l_row['isys_obj__title'] . '</a>',
                            date('d.m.Y H:i:s', strtotime($l_row['isys_logbook__date'])),
                            $l_row['isys_logbook__user_name_static'],
                            $l_change_from,
                            $l_change_to,
                            $l_row['isys_catg_model_list__serial']
                        ];
                    }
                }
            }
        }

        // Finally assign the data to the template.
        isys_application::instance()->template->activate_editmode()
            ->assign('data', $l_return)
            ->assign('from', $_POST['C__CALENDAR_FROM__HIDDEN'])
            ->assign('to', $_POST['C__CALENDAR_TO__HIDDEN'])
            ->assign('g_dirs', $g_dirs);
    }

    /**
     * Method for retrieving the template-name of this report.
     *
     * @return  string
     * @author  Leonard Fischer <lfischer@i-doit.org>
     * @todo    Should we update the parent method to retrieve this automatically?
     */
    public function template()
    {
        return 'view_accounting.tpl';
    }

    /**
     * Method for declaring the type of this report.
     *
     * @return  integer
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public static function type()
    {
        return self::c_php_view;
    }

    /**
     * Method for declaring the view-type.
     *
     * @return  string
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public static function viewtype()
    {
        return 'LC__CMDB__OBJTYPE__CATG';
    }
}
