<?php

/**
 * i-doit
 *
 * @package     i-doit
 * @subpackage  Popups
 * @author      Dennis Stücken <dstuecken@synetics.de>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_popup_ocs_category_selection extends isys_component_popup
{
    /**
     *
     * @return string
     */
    public function handle_smarty_include(isys_component_template &$p_tplclass, $p_params)
    {
        return $this->process(isys_helper_link::create_url([
            'mod'   => 'cmdb',
            'popup' => 'ocs_category_selection'
        ]), true);
    }

    /**
     *
     * @param  isys_module_request $p_modreq
     *
     * @return isys_component_template&
     * @throws Exception
     */
    public function &handle_module_request(isys_module_request $p_modreq)
    {
        $l_categories = [
            $this->lang->get("LC__OBJTYPE__OPERATING_SYSTEM")            => "operating_system",
            $this->lang->get("LC__CMDB__CATG__COMPUTING_RESOURCES__CPU") => C__CATG__CPU,
            $this->lang->get("LC__CMDB__CATG__MEMORY")                   => C__CATG__MEMORY,
            $this->lang->get("LC__CMDB__CATG__APPLICATION")              => C__CATG__APPLICATION,
            $this->lang->get("LC__CMDB__CATG__NETWORK")                  => C__CATG__NETWORK,
            $this->lang->get("LC__UNIVERSAL__DEVICES")                   => C__CATG__STORAGE,
            $this->lang->get("LC__UNIVERSAL__DRIVES")                    => C__CATG__DRIVE,
            $this->lang->get("LC__CMDB__CATG__GRAPHIC")                  => C__CATG__GRAPHIC,
            $this->lang->get("LC__CMDB__CATG__SOUND")                    => C__CATG__SOUND,
            $this->lang->get("LC__CMDB__CATG__MODEL")                    => C__CATG__MODEL,
            $this->lang->get("LC__CMDB__CATG__UNIVERSAL_INTERFACE")      => C__CATG__UNIVERSAL_INTERFACE
        ];

        return isys_application::instance()->container->get('template')
            ->assign("file_body", "popup/ocs_category_selection.tpl")
            ->assign("categories", $l_categories);
    }
}
