<?php

/**
 * i-doit
 *
 * Workflow Popup for creating workflows with an ajax request or popup
 *
 * @package    i-doit
 * @subpackage Popups
 * @author     Dennis Stücken <dstuecken@synetics.de>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_popup_workflow extends isys_component_popup
{
    /**
     * @param isys_component_template $p_tplclass
     * @param                         $p_params
     * @param null                    $p_display_magnifier
     * @param bool                    $p_url_only
     *
     * @return string
     */
    public function handle_smarty_include(isys_component_template &$p_tplclass, $p_params, $p_display_magnifier = null, $p_url_only = false)
    {
        $l_url = "?mod=cmdb&popup=workflow";

        $this->set_config("width", 950);
        $this->set_config("height", 720);

        $p_params["p_bReadonly"] = "1";

        $l_objPlugin = new isys_smarty_plugin_f_text();

        if (isys_glob_get_param("editMode") == C__EDITMODE__ON) {
            $l_strOut = $l_objPlugin->navigation_edit($p_tplclass, $p_params) .
                '<a href="javascript:void(0); title="' . $this->lang->get('LC_WORKFLOW__CREATION') . '"  style="margin-left:5px;" onClick="' . $this->process($l_url, true) . ';" ></a>';
        } else {
            $p_params['p_bHtmlDecode'] = true;

            $l_strOut = $l_objPlugin->navigation_view($p_tplclass, $p_params);
        }

        // Return onclick, or full html
        if ($p_url_only) {
            return $l_url;
        } else {
            return $l_strOut;
        }
    }

    /**
     * @param isys_module_request $p_modreq
     * @param bool                $p_module_request
     */
    public function &handle_ajax_request(isys_module_request $p_modreq, $p_module_request = false)
    {
        $this->handle($p_modreq, $p_module_request);
    }

    /**
     * @param isys_module_request $p_modreq
     *
     * @return isys_component_template|void
     */
    public function &handle_module_request(isys_module_request $p_modreq)
    {
        $this->handle($p_modreq, false);
    }

    /**
     * @param isys_module_request $p_modreq
     * @param                     $p_module_request
     *
     * @return isys_component_template
     * @throws Exception
     */
    public function handle(isys_module_request $p_modreq, $p_module_request)
    {
        // Unpack module request.
        $l_gets = $p_modreq->get_gets();
        $l_tpl = isys_application::instance()->container->get('template');

        // Get dao for template handler.
        $l_workflow_template = new isys_workflow_dao_template($this->db);
        $l_workflow_type_dao = new isys_workflow_dao_type($this->db);

        $l_wf_tmp = $l_workflow_type_dao->get_workflow_types($l_gets[C__WF__GET__TYPE]);

        if (count($l_wf_tmp)) {
            $l_dao_wf = new isys_workflow_dao($this->db);
            $l_workflow_type = $l_wf_tmp->get_row();

            $l_tpl->assign("g_occurrence", $l_workflow_type["isys_workflow_type__occurrence"])
                ->assign("g_occurrence_data", $l_dao_wf->get_occurrence_data());
        }

        $l_tpl->assign("g_template_parameter", $l_workflow_template->get_template_parameter($l_gets[C__WF__GET__TYPE]))
            ->assign("g_workflow_type", $l_gets[C__WF__GET__TYPE])
            ->assign("g_ar_yes_no", get_smarty_arr_YES_NO());

        if ($p_module_request) {
            return $l_tpl;
        } else {
            return $l_tpl->display("workflow/detail/generic.tpl");
        }
    }
}
