<?php
/**
 * i-doit Module interface for activation
 *
 * @package     idoit\Component
 * @author      atsapko
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

namespace idoit\AddOn;

interface ActivatableInterface
{
    /**
     * Checks if a module is active.
     *
     * @return integer|bool
     */
    public static function isActive();

    /**
     * Method that is called after clicking "activate" in admin center for specific mandator
     *
     * @param isys_component_database $mandatorDb
     *
     * @return boolean
     * @author atsapko
     */
    public static function activate($mandatorDb);

    /**
     * Method that is called after clicking "deactivate" in admin center for specific mandator
     *
     * @param isys_component_database $mandatorDb
     *
     * @return boolean
     * @author atsapko
     */
    public static function deactivate($mandatorDb);
}