<?php

namespace idoit\Component\Browser;

interface ConditionInterface
{
    /**
     * @param mixed $parameter
     *
     * @return $this
     */
    public function setParameter($parameter);

    /**
     * Method for retrieving the object overview (available parameters).
     *
     * @return array
     */
    public function retrieveOverview();

    /**
     * Method for retrieving the objects.
     *
     * @return array
     */
    public function retrieveObjects();

    /**
     * @param FilterInterface $filter
     *
     * @return $this
     */
    public function registerFilter(FilterInterface $filter);

    /**
     * Method that defines if the object order should be retained (necessary for "date" condition).
     *
     * @return boolean
     */
    public function retainObjectOrder();

    /**
     * Indicates whether grouping is needed
     *
     * @return bool
     */
    public function needsGrouping();
}