<?php

namespace idoit\Component\Document;

use Knp\Snappy\Pdf as SnappyPdf;

/**
 * i-doit Pdf Document Component
 *
 * @author      kmauel <kmauel@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Pdf extends SnappyPdf
{
    public function enableTableOfContents()
    {
        $this->setOption('toc', true);
    }

    public function disableTableOfContents()
    {
        $this->setOption('toc', false);
    }

    /**
     * Adds cover page with either html string or path to a html file
     *
     * @param string $coverHtml
     */
    public function addCover($coverHtml)
    {
        $this->setOption('cover', $coverHtml);
    }
}
