<?php
/**
 * i-doit - Updates
 *
 * Migrating values in "power_consumer" and "power_supplier" to float values.
 *
 * @package     i-doit
 * @subpackage  Update
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @author      Leonard Fischer <lfischer@i-doit.com>
 */

/**
 * @var $g_comp_database isys_component_database
 */
global $g_comp_database;

$g_migration_identifier = "power_migration";

if ($this->is_migration_done($g_migration_identifier)) {
    $g_migration_log[] = '<span class="bold">Power (Volt, Ampere, Watt) data migration has already been done.</span>';
} else {
    $g_migration_log[] = '<span class="bold">Startin migration of Power (Volt, Ampere, Watt) data.</span>';

    $dao = isys_cmdb_dao::instance($g_comp_database);

    $tables = [
        'isys_catg_power_supplier_list' => 'power supplier',
        'isys_catg_pc_list'             => 'power consumer'
    ];

    foreach ($tables as $table => $catName) {
        $sql = 'SELECT isys_obj__id AS objId, isys_obj__title AS objTitle, ' . $table . '__id AS id, ' . $table . '__volt AS volt, ' . $table . '__watt AS watt, ' . $table . '__ampere AS ampere
            FROM ' . $table . '
            INNER JOIN isys_obj ON isys_obj__id = ' . $table . '__isys_obj__id 
            WHERE ' . $table . '__volt <> ""
            OR ' . $table . '__watt <> ""
            OR ' . $table . '__ampere <> "";';

        $result = $dao->retrieve($sql);

        while ($row = $result->get_row()) {
            try {
                $changes = [];
                $newValues = [];

                $volt = isys_helper::filter_number($row['volt']);
                $watt = isys_helper::filter_number($row['watt']);
                $ampere = isys_helper::filter_number($row['ampere']);

                if (isys_strlen($row['volt']) && isys_strlen($volt) !== isys_strlen($row['volt'])) {
                    $changes[] = '<code style="margin:0;">' . $row['volt'] . '</code> to <code style="margin:0;">' . $volt . '</code>';
                    $newValues[] = $table . '__volt = ' . $dao->convert_sql_float($volt);
                }

                if (isys_strlen($row['watt']) && isys_strlen($watt) !== isys_strlen($row['watt'])) {
                    $changes[] = '<code style="margin:0;">' . $row['watt'] . '</code> to <code style="margin:0;">' . $watt . '</code>';
                    $newValues[] = $table . '__watt = ' . $dao->convert_sql_float($watt);
                }

                if (isys_strlen($row['ampere']) && isys_strlen($ampere) !== isys_strlen($row['ampere'])) {
                    $changes[] = '<code style="margin:0;">' . $row['ampere'] . '</code> to <code style="margin:0;">' . $ampere . '</code>';
                    $newValues[] = $table . '__ampere = ' . $dao->convert_sql_float($ampere);
                }

                if (count($changes)) {
                    $g_migration_log[] = '<span class="indent bold">Changed ' . $catName . ' data in "' . $row['objTitle'] . '" (#' . $row['objId'] . ') from ' . implode(', ', $changes) . '</span>';

                    $dao->update('UPDATE ' . $table . ' SET ' . implode(', ', $newValues) . ' WHERE ' . $table . '__id = ' . $dao->convert_sql_id($row['id']) . ';') && $dao->apply_update();
                }
            } catch (Exception $e) {
                $g_migration_log[] = '<span class="indent red bold">Error: ' . $e->getMessage() . '</span>';
            }
        }
    }

    $g_migration_log[] = '<span class="bold">Finished migration!</span>';

    $this->migration_done($g_migration_identifier);
}