<?php

/**
 * AJAX
 *
 * @package     i-doit
 * @subpackage  General
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_ajax_handler_connector extends isys_ajax_handler
{

    /**
     * Init
     *
     * @throws \Exception if method is unkown
     */
    public function init()
    {
        $l_method = $_GET['method'];

        switch ($l_method) {
            case 'get_fiber_lead':
                $l_return = $this->get_fiber_lead((int)$_POST['cable_object_id'], (int)$_POST['connector_id']);
                break;

            case 'load_listeners':
                $l_return = $this->load_listeners((int)$_POST['id']);
                break;

            case 'detachConnector':
                $l_return = $this->detach_connector(array_filter(explode(',', $_POST['connector'])));
                break;

            case 'connectConnectors':
                $l_return = $this->attach_connector(array_filter(explode(',', $_POST['a'])), array_filter(explode(',', $_POST['b'])));
                break;

            default:
                throw new \Exception(sprintf('unknown method "%s"', $l_method));
        }

        header('Content-Type: application/json');
        echo isys_format_json::encode($l_return);
        $this->_die();
    }

    /**
     * @param   integer $p_cable_object_id
     * @param   integer $p_connector_id
     *
     * @return  array
     * @throws  Exception
     * @throws  isys_exception_database
     * @throws  isys_exception_general
     */
    protected function get_fiber_lead($p_cable_object_id, $p_connector_id)
    {
        $l_dao = isys_cmdb_dao_category_g_fiber_lead::instance($this->m_database_component);

        $l_fibers_leads = $l_dao->get_data_by_object($p_cable_object_id)
            ->__as_array();

        $l_sql = 'SELECT isys_catg_connector_list__id, isys_catg_connector_list__used_fiber_lead_rx, isys_catg_connector_list__used_fiber_lead_tx
            FROM isys_catg_connector_list
            INNER JOIN isys_catg_fiber_lead_list AS rx ON rx.isys_catg_fiber_lead_list__id = isys_catg_connector_list__used_fiber_lead_rx
            INNER JOIN isys_catg_fiber_lead_list AS tx ON tx.isys_catg_fiber_lead_list__id = isys_catg_connector_list__used_fiber_lead_tx
            WHERE isys_catg_connector_list__id = ' . $l_dao->convert_sql_id($p_connector_id) . '
            AND (rx.isys_catg_fiber_lead_list__isys_obj__id = ' . $l_dao->convert_sql_id($p_cable_object_id) . ' OR
                tx.isys_catg_fiber_lead_list__isys_obj__id = ' . $l_dao->convert_sql_id($p_cable_object_id) . ');';

        $l_used_fibers_leads = $l_dao->retrieve($l_sql)
            ->__as_array();

        $l_options = [];

        foreach ($l_fibers_leads as $l_fiber_lead) {
            $l_option = [
                'isys_catg_fiber_lead_list__id'    => $l_fiber_lead['isys_catg_fiber_lead_list__id'],
                'isys_catg_fiber_lead_list__label' => $l_fiber_lead['isys_catg_fiber_lead_list__label'],
                'isys_fiber_category__title'       => $l_fiber_lead['isys_fiber_category__title'],
                'isys_cable_colour__title'         => $l_fiber_lead['isys_cable_colour__title'],
                'disabled'                         => false
            ];

            foreach ($l_used_fibers_leads as $l_used_fiber_lead) {
                if ($l_fiber_lead['isys_catg_fiber_lead__id'] === $l_used_fiber_lead['isys_catg_connector_list__used_fiber_lead_rx'] ||
                    $l_fiber_lead['isys_catg_fiber_lead__id'] === $l_used_fiber_lead['isys_catg_connector_list__used_fiber_lead_rx']) {
                    $l_option['disabled'] = true;
                    break;
                }
            }

            $l_options[] = $l_option;
        }

        return $l_options;
    }

    /**
     * Method which retrieves all listeners of the selected object
     *
     * @param $p_obj_id
     *
     * @return array
     * @throws isys_exception_general
     * @author Van Quyen Hoang <qhoang@i-doit.com>
     */
    private function load_listeners($p_obj_id)
    {
        $l_dao = isys_cmdb_dao_category_g_net_listener::instance(isys_application::instance()->database);
        $l_res = $l_dao->get_data(null, $p_obj_id);
        $l_return = [];

        if ($l_res->num_rows()) {
            while ($l_row = $l_res->get_row()) {
                $l_return[$l_row['isys_catg_net_listener_list__id']] = $l_row['isys_net_protocol__title'] . '/' . $l_row['isys_cats_net_ip_addresses_list__title'] . ':' .
                    $l_row['isys_catg_net_listener_list__port_from'] . ' | ' . $l_row['isys_obj__title'];
            }
        }

        return $l_return;
    }

    /**
     * Method for detaching a connector.
     *
     * @param array $p_connectors
     *
     * @return array
     */
    protected function detach_connector(array $p_connectors)
    {
        $l_return = ['success' => true, 'data' => [], 'message' => ''];

        try {
            $l_dao = isys_cmdb_dao_cable_connection::instance(isys_application::instance()->database);

            foreach ($p_connectors as $l_connector) {
                $l_connection_id = $l_dao->get_cable_connection_id_by_connector_id((int)$l_connector);

                if (isys_tenantsettings::get('cmdb.cable.change-cmdb-status-on-detach', 1)) {
                    $l_cable_object_id = $l_dao->get_cable_object_id_by_connection_id($l_connection_id);

                    $l_dao->set_object_cmdb_status($l_cable_object_id, C__CMDB_STATUS__INOPERATIVE);
                }

                $l_return['data'][] = $l_dao->delete_cable_connection($l_connection_id);
            }
        } catch (Exception $e) {
            $l_return['success'] = false;
            $l_return['message'] = $e->getMessage();
        }

        return $l_return;
    }

    /**
     * Method for connecting two connectors with each other.
     *
     * @param array $p_connectors_a
     * @param array $p_connectors_b
     *
     * @return array
     */
    protected function attach_connector(array $p_connectors_a, array $p_connectors_b)
    {
        $l_return = ['success' => true, 'data' => [], 'message' => ''];
        $l_counter = count($p_connectors_a);

        try {
            if (empty($p_connectors_a) || empty($p_connectors_b)) {
                throw new Exception('At least two connectors needed to connect!');
            }

            $l_dao = isys_cmdb_dao_cable_connection::instance(isys_application::instance()->database);
            $l_dao_connector = isys_cmdb_dao_category_g_connector::instance(isys_application::instance()->database);

            for ($i = 0;$i < $l_counter;$i++) {
                // Remove the current cable connection of the local and destination controller.
                $this->detach_connector([$p_connectors_a[$i], $p_connectors_b[$i]]);

                $p_cableID = isys_cmdb_dao_cable_connection::add_cable();

                $l_cable_con = $l_dao->add_cable_connection($p_cableID);

                if (!$l_dao->save_connection($p_connectors_a[$i], $p_connectors_b[$i], $l_cable_con, $p_connectors_a[$i])) {
                    $l_return['data'][] = false;
                } else {
                    if (isys_tenantsettings::get('cmdb.cable.change-cmdb-status-on-attach', 1)) {
                        $l_dao->set_object_cmdb_status($p_cableID, C__CMDB_STATUS__IN_OPERATION);
                    }

                    $l_destination_data = $l_dao_connector->get_data($p_connectors_b[$i])
                        ->get_row();

                    $l_return['data'][] = [
                        'objId'      => $l_destination_data['isys_obj__id'],
                        'objTitle'   => $l_destination_data['isys_obj__title'],
                        'connId'     => $p_connectors_b[$i],
                        'connTitle'  => $l_destination_data['isys_catg_connector_list__title'],
                        'cableId'    => $l_destination_data['cable_object'],
                        'cableTitle' => $l_destination_data['cable_title']
                    ];
                }
            }
        } catch (Exception $e) {
            $l_return['success'] = false;
            $l_return['message'] = $e->getMessage();
        }

        return $l_return;
    }
}
