<?php

use idoit\Component\Helper\Ip;

/**
 * i-doit
 *
 * Export helper for Check_MK
 *
 * @package     i-doit
 * @subpackage  Export
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_export_helper_check_mk extends isys_export_helper
{
    /**
     * Get dialog plus information by id.
     *
     * @param   integer $p_id
     * @param   boolean $p_table
     *
     * @return  array
     */
    public function hostaddress($p_id, $p_table = false)
    {
        if ($p_id === 0 || $p_id === '0') {
            return [
                'id'         => 0,
                'title'      => isys_application::instance()->container->get('language')
                    ->get('LC__CATG__IP__PRIMARY_IP_ADDRESS'),
                'const'      => '',
                'title_lang' => 'LC__CATG__IP__PRIMARY_IP_ADDRESS'
            ];
        }

        return $this->dialog_plus($p_id, $p_table);
    }

    /**
     * @param   mixed  $p_data
     * @param   string $p_table
     *
     * @return  integer  Value's valid identifier existing in database
     */
    public function hostaddress_import($p_data, $p_table = null)
    {
        if (is_array($p_data)) {
            if ($p_data['title_lang'] == 'LC__CATG__IP__PRIMARY_IP_ADDRESS') {
                return 0;
            } else if (Ip::validate_ip($p_data[C__DATA__VALUE])) {
                return $this->m_category_data_ids[C__CMDB__CATEGORY__TYPE_GLOBAL][C__CATG__IP][$p_data['id']];
            }
        }

        return $this->dialog_plus_import($p_data, $p_table);
    }

    /**
     * Retrieves connected parent objects from a given check_mk export parameter category entry.
     *
     * @param integer $dataId
     *
     * @return bool|isys_export_data
     * @throws isys_exception_database
     * @author  Van Quyen Hoang <qhoang@i-doit.org>
     */
    public function chmkExportParents($dataId)
    {
        $result = isys_cmdb_dao_category_g_cmk::instance($this->m_database)
            ->getExportParents($dataId);

        if (count($result)) {
            $resultData = [];

            while ($data = $result->get_row()) {
                $resultData[] = [
                    'id'    => $data['isys_obj__id'],
                    'sysid' => $data['isys_obj__sysid'],
                    'title' => $data['isys_obj__title'],
                    'type'  => $data['isys_obj_type__const']
                ];
            }

            return new isys_export_data($resultData);
        }

        return false;
    }

    /**
     * Retrieves parent object IDs from given data.
     *
     * @param array $data
     *
     * @return array
     * @author  Van Quyen Hoang <qhoang@i-doit.org>
     */
    public function chmkExportParents_import(array $data)
    {
        $return = [];

        if (is_array($data[C__DATA__VALUE])) {
            foreach ($data[C__DATA__VALUE] AS $dataItem) {
                if (array_key_exists($dataItem['id'], $this->m_object_ids)) {
                    $return[] = $this->m_object_ids[$dataItem['id']];
                }
            }
        } elseif ($data[C__DATA__VALUE] > 0) {
            $return[] = $data[C__DATA__VALUE];
        }

        return $return;
    }
}
